/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.console.options.AvailableOptions;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.shadow.joptsimple.BuiltinHelpFormatter;
import org.junit.platform.console.shadow.joptsimple.OptionDescriptor;
import org.junit.platform.console.shadow.joptsimple.OptionParser;
import org.junit.platform.console.shadow.joptsimple.OptionSet;

@API(status=API.Status.INTERNAL, since="1.0")
public class JOptSimpleCommandLineOptionsParser
implements CommandLineOptionsParser {
    @Override
    public CommandLineOptions parse(String ... arguments) {
        AvailableOptions availableOptions = this.getAvailableOptions();
        OptionParser parser = availableOptions.getParser();
        try {
            OptionSet detectedOptions = parser.parse(arguments);
            return availableOptions.toCommandLineOptions(detectedOptions);
        }
        catch (Exception e) {
            throw new JUnitException("Error parsing command-line arguments", (Throwable)e);
        }
    }

    @Override
    public void printHelp(Writer writer) {
        OptionParser optionParser = this.getAvailableOptions().getParser();
        optionParser.formatHelpWith(new OrderPreservingHelpFormatter());
        try {
            optionParser.printHelpOn(writer);
        }
        catch (IOException e) {
            throw new JUnitException("Error printing help", (Throwable)e);
        }
    }

    private AvailableOptions getAvailableOptions() {
        return new AvailableOptions();
    }

    private static final class OrderPreservingHelpFormatter
    extends BuiltinHelpFormatter {
        private OrderPreservingHelpFormatter() {
            super(90, 4);
        }

        @Override
        public String format(Map<String, ? extends OptionDescriptor> options) {
            this.addRows(new LinkedHashSet<OptionDescriptor>(options.values()));
            return this.formattedHelpOutput();
        }
    }
}

