/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.junit.platform.console.command.BaseCommand;
import org.junit.platform.console.command.CommandResult;
import org.junit.platform.console.command.ConsoleTestExecutor;
import org.junit.platform.console.command.DiscoverTestsCommand;
import org.junit.platform.console.command.ExecuteTestsCommand;
import org.junit.platform.console.command.ListTestEnginesCommand;
import org.junit.platform.console.command.ManifestVersionProvider;
import org.junit.platform.console.command.OutputStreamConfig;
import org.junit.platform.console.options.AnsiColorOptionMixin;
import org.junit.platform.console.shadow.picocli.CommandLine;

@CommandLine.Command(name="junit", abbreviateSynopsis=true, sortOptions=false, usageHelpWidth=95, showAtFileInUsageHelp=true, usageHelpAutoWidth=true, description={"Launches the JUnit Platform for test discovery and execution."}, footerHeading="%n", footer={"For more information, please refer to the JUnit User Guide at%n@|underline https://docs.junit.org/${junit.docs.version}/user-guide/|@"}, scope=CommandLine.ScopeType.INHERIT, exitCodeOnInvalidInput=-1, exitCodeOnExecutionException=-1, versionProvider=ManifestVersionProvider.class)
class MainCommand
implements Callable<Object>,
CommandLine.IExitCodeGenerator {
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;
    @CommandLine.Option(names={"-h", "--help"}, help=true, description={"Display help information."})
    private boolean helpRequested;
    @CommandLine.Option(names={"--h", "-help"}, help=true, hidden=true)
    private boolean helpRequested2;
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"Display version information."})
    private boolean versionHelpRequested;
    @CommandLine.Mixin
    AnsiColorOptionMixin ansiColorOption;
    @CommandLine.Unmatched
    private List<String> allParameters = new ArrayList<String>();
    @CommandLine.Spec
    CommandLine.Model.CommandSpec commandSpec;
    CommandResult<?> commandResult;

    MainCommand(ConsoleTestExecutor.Factory consoleTestExecutorFactory) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
    }

    @Override
    public Object call() {
        if (this.helpRequested || this.helpRequested2) {
            this.commandSpec.commandLine().usage(this.commandSpec.commandLine().getOut());
            this.commandResult = CommandResult.success();
            return null;
        }
        if (this.versionHelpRequested) {
            this.commandSpec.commandLine().printVersionHelp(this.commandSpec.commandLine().getOut());
            this.commandResult = CommandResult.success();
            return null;
        }
        if (this.allParameters.contains("--list-engines")) {
            return this.runCommand("engines", Optional.of("--list-engines"));
        }
        return this.runCommand("execute", Optional.empty());
    }

    @Override
    public int getExitCode() {
        return this.commandResult.getExitCode();
    }

    private Object runCommand(String subcommand, Optional<String> triggeringOption) {
        CommandLine commandLine = this.commandSpec.commandLine();
        commandLine.setUnmatchedArgumentsAllowed(false);
        Object command = commandLine.getSubcommands().get(subcommand).getCommandSpec().userObject();
        ArrayList<String> args = new ArrayList<String>(commandLine.getParseResult().expandedArgs());
        triggeringOption.ifPresent(args::remove);
        CommandResult<?> result = MainCommand.runCommand(new CommandLine(command), args.toArray(new String[0]), Optional.of(new OutputStreamConfig(commandLine)));
        this.commandResult = result;
        MainCommand.printDeprecationWarning(subcommand, triggeringOption, commandLine);
        return result.getValue().orElse(null);
    }

    private static void printDeprecationWarning(String subcommand, Optional<String> triggeringOption, CommandLine commandLine) {
        PrintWriter err = commandLine.getErr();
        String reason = triggeringOption.map(it -> " due to use of '" + it + "'").orElse("");
        commandLine.getOut().flush();
        err.println();
        CommandLine.Help.ColorScheme colorScheme = commandLine.getColorScheme();
        err.println(colorScheme.string(String.format("@|yellow,bold WARNING:|@ Delegated to the '%s' command%s.", subcommand, reason)));
        err.println(colorScheme.string("         This behaviour has been deprecated and will be removed in a future release."));
        err.println(colorScheme.string("         Please use the '" + subcommand + "' command directly."));
        err.flush();
    }

    CommandResult<?> run(String[] args, Optional<OutputStreamConfig> outputStreamConfig) {
        CommandLine commandLine = new CommandLine(this).addSubcommand(new DiscoverTestsCommand(this.consoleTestExecutorFactory)).addSubcommand(new ExecuteTestsCommand(this.consoleTestExecutorFactory)).addSubcommand(new ListTestEnginesCommand());
        return MainCommand.runCommand(commandLine, args, outputStreamConfig);
    }

    private static CommandResult<?> runCommand(CommandLine commandLine, String[] args, Optional<OutputStreamConfig> outputStreamConfig) {
        BaseCommand.initialize(commandLine);
        outputStreamConfig.ifPresent(it -> it.applyTo(commandLine));
        int exitCode = commandLine.execute(args);
        return CommandResult.create(exitCode, MainCommand.getLikelyExecutedCommand(commandLine).getExecutionResult());
    }

    private static CommandLine getLikelyExecutedCommand(CommandLine commandLine) {
        return Optional.ofNullable(commandLine.getParseResult().subcommand()).map(parseResult -> parseResult.commandSpec().commandLine()).orElse(commandLine);
    }
}

