/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.command;

import java.io.PrintWriter;
import java.util.concurrent.Callable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.console.command.BannerOptionMixin;
import org.junit.platform.console.options.AnsiColorOptionMixin;
import org.junit.platform.console.shadow.picocli.CommandLine;

abstract class BaseCommand<T>
implements Callable<T> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Mixin
    AnsiColorOptionMixin ansiColorOption;
    @CommandLine.Mixin
    BannerOptionMixin bannerOption;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display help information."})
    private boolean helpRequested;
    @CommandLine.Option(names={"--version"}, versionHelp=true, description={"Display version information."})
    private boolean versionHelpRequested;

    BaseCommand() {
    }

    void execute(String ... args) {
        this.toCommandLine().execute(args);
    }

    void parseArgs(String ... args) {
        this.toCommandLine().parseArgs(args);
    }

    private CommandLine toCommandLine() {
        return BaseCommand.initialize(new CommandLine(this));
    }

    static CommandLine initialize(CommandLine commandLine) {
        CommandLine.IParameterExceptionHandler defaultParameterExceptionHandler = commandLine.getParameterExceptionHandler();
        return commandLine.setParameterExceptionHandler((ex, args) -> {
            defaultParameterExceptionHandler.handleParseException(ex, args);
            return -1;
        }).setExecutionExceptionHandler((ex, cmd, __) -> {
            commandLine.getErr().println(cmd.getColorScheme().richStackTraceString(ex));
            commandLine.getErr().println();
            commandLine.getErr().flush();
            cmd.usage(commandLine.getOut());
            return -1;
        }).setCaseInsensitiveEnumValuesAllowed(true).setAtFileCommentChar(null);
    }

    @Override
    public final T call() {
        PrintWriter out = this.getOut();
        if (!this.bannerOption.isDisableBanner()) {
            this.displayBanner(out);
        }
        try {
            return this.execute(out);
        }
        catch (PreconditionViolationException e) {
            throw new CommandLine.ParameterException(this.commandSpec.commandLine(), e.getMessage(), e.getCause());
        }
    }

    private PrintWriter getOut() {
        return this.commandSpec.commandLine().getOut();
    }

    private void displayBanner(PrintWriter out) {
        out.println();
        CommandLine.Help.ColorScheme colorScheme = this.getColorScheme();
        if (colorScheme.ansi().enabled()) {
            out.print("\ud83d\udc9a ");
        }
        out.println(colorScheme.string("@|italic Thanks for using JUnit!|@ Support its development at @|underline https://junit.org/sponsoring|@"));
        out.println();
        out.flush();
    }

    protected final CommandLine.Help.ColorScheme getColorScheme() {
        return this.commandSpec.commandLine().getColorScheme();
    }

    protected abstract T execute(PrintWriter var1);
}

