/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.platform.console.tasks.CustomClassLoaderCloseStrategy;

class CustomContextClassLoaderExecutor {
    private final Optional<ClassLoader> customClassLoader;
    private final CustomClassLoaderCloseStrategy closeStrategy;

    CustomContextClassLoaderExecutor(Optional<ClassLoader> customClassLoader) {
        this(customClassLoader, CustomClassLoaderCloseStrategy.CLOSE_AFTER_CALLING_LAUNCHER);
    }

    CustomContextClassLoaderExecutor(Optional<ClassLoader> customClassLoader, CustomClassLoaderCloseStrategy closeStrategy) {
        this.customClassLoader = customClassLoader;
        this.closeStrategy = closeStrategy;
    }

    <T> T invoke(Supplier<T> supplier) {
        if (this.customClassLoader.isPresent()) {
            return this.replaceThreadContextClassLoaderAndInvoke(this.customClassLoader.get(), supplier);
        }
        return supplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T replaceThreadContextClassLoaderAndInvoke(ClassLoader customClassLoader, Supplier<T> supplier) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(customClassLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this.closeStrategy.handle(customClassLoader);
        }
    }
}

