/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="1.10")
public class CommandResult<T> {
    public static final int SUCCESS = 0;
    protected static final int FAILURE = -1;
    private final int exitCode;
    private final T value;

    public static <T> CommandResult<T> success() {
        return CommandResult.create(0, null);
    }

    public static <T> CommandResult<T> failure() {
        return CommandResult.create(-1, null);
    }

    public static <T> CommandResult<T> create(int exitCode, T value) {
        return new CommandResult<T>(exitCode, value);
    }

    private CommandResult(int exitCode, T value) {
        this.exitCode = exitCode;
        this.value = value;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }
}

