/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.console.options.Details;
import org.junit.platform.console.options.TestConsoleOutputOptions;
import org.junit.platform.console.options.TestDiscoveryOptions;
import org.junit.platform.console.options.Theme;
import org.junit.platform.console.tasks.ColorPalette;
import org.junit.platform.console.tasks.CustomContextClassLoaderExecutor;
import org.junit.platform.console.tasks.DetailsPrintingListener;
import org.junit.platform.console.tasks.DiscoveryRequestCreator;
import org.junit.platform.console.tasks.FlatPrintingListener;
import org.junit.platform.console.tasks.TestFeedPrintingListener;
import org.junit.platform.console.tasks.TreePrintingListener;
import org.junit.platform.console.tasks.VerboseTreePrintingListener;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.junit.platform.reporting.legacy.xml.LegacyXmlReportGeneratingListener;

@API(status=API.Status.INTERNAL, since="1.0")
public class ConsoleTestExecutor {
    private final TestDiscoveryOptions discoveryOptions;
    private final TestConsoleOutputOptions outputOptions;
    private final Supplier<Launcher> launcherSupplier;

    public ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions) {
        this(discoveryOptions, outputOptions, LauncherFactory::create);
    }

    ConsoleTestExecutor(TestDiscoveryOptions discoveryOptions, TestConsoleOutputOptions outputOptions, Supplier<Launcher> launcherSupplier) {
        this.discoveryOptions = discoveryOptions;
        this.outputOptions = outputOptions;
        this.launcherSupplier = launcherSupplier;
    }

    public void discover(PrintWriter out) {
        new CustomContextClassLoaderExecutor(this.createCustomClassLoader()).invoke(() -> {
            this.discoverTests(out);
            return null;
        });
    }

    public TestExecutionSummary execute(PrintWriter out, Optional<Path> reportsDir) {
        return new CustomContextClassLoaderExecutor(this.createCustomClassLoader()).invoke(() -> this.executeTests(out, reportsDir));
    }

    private void discoverTests(PrintWriter out) {
        Launcher launcher = this.launcherSupplier.get();
        Optional<DetailsPrintingListener> commandLineTestPrinter = this.createDetailsPrintingListener(out);
        LauncherDiscoveryRequest discoveryRequest = DiscoveryRequestCreator.toDiscoveryRequestBuilder(this.discoveryOptions).build();
        TestPlan testPlan = launcher.discover(discoveryRequest);
        commandLineTestPrinter.ifPresent(printer -> printer.listTests(testPlan));
        if (this.outputOptions.getDetails() != Details.NONE) {
            ConsoleTestExecutor.printFoundTestsSummary(out, testPlan);
        }
    }

    private static void printFoundTestsSummary(PrintWriter out, TestPlan testPlan) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        summaryListener.testPlanExecutionStarted(testPlan);
        TestExecutionSummary summary = summaryListener.getSummary();
        out.printf("%n[%10d containers found ]%n[%10d tests found      ]%n%n", summary.getContainersFoundCount(), summary.getTestsFoundCount());
        out.flush();
    }

    private TestExecutionSummary executeTests(PrintWriter out, Optional<Path> reportsDir) {
        Launcher launcher = this.launcherSupplier.get();
        SummaryGeneratingListener summaryListener = this.registerListeners(out, reportsDir, launcher);
        LauncherDiscoveryRequestBuilder discoveryRequestBuilder = DiscoveryRequestCreator.toDiscoveryRequestBuilder(this.discoveryOptions);
        reportsDir.ifPresent(dir -> discoveryRequestBuilder.configurationParameter("junit.platform.reporting.output.dir", dir.toAbsolutePath().toString()));
        launcher.execute(discoveryRequestBuilder.build(), new TestExecutionListener[0]);
        TestExecutionSummary summary = summaryListener.getSummary();
        if (summary.getTotalFailureCount() > 0L || this.outputOptions.getDetails() != Details.NONE) {
            this.printSummary(summary, out);
        }
        return summary;
    }

    private Optional<ClassLoader> createCustomClassLoader() {
        List<Path> additionalClasspathEntries = this.discoveryOptions.getExistingAdditionalClasspathEntries();
        if (!additionalClasspathEntries.isEmpty()) {
            URL[] urls = (URL[])additionalClasspathEntries.stream().map(this::toURL).toArray(URL[]::new);
            ClassLoader parentClassLoader = ClassLoaderUtils.getDefaultClassLoader();
            URLClassLoader customClassLoader = URLClassLoader.newInstance(urls, parentClassLoader);
            return Optional.of(customClassLoader);
        }
        return Optional.empty();
    }

    private URL toURL(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (Exception ex) {
            throw new JUnitException("Invalid classpath entry: " + path, (Throwable)ex);
        }
    }

    private SummaryGeneratingListener registerListeners(PrintWriter out, Optional<Path> reportsDir, Launcher launcher) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
        this.createDetailsPrintingListener(out).ifPresent(xva$0 -> launcher.registerTestExecutionListeners(new TestExecutionListener[]{xva$0}));
        this.createXmlWritingListener(out, reportsDir).ifPresent(xva$0 -> launcher.registerTestExecutionListeners(new TestExecutionListener[]{xva$0}));
        return summaryListener;
    }

    private Optional<DetailsPrintingListener> createDetailsPrintingListener(PrintWriter out) {
        ColorPalette colorPalette = this.getColorPalette();
        Theme theme = this.outputOptions.getTheme();
        switch (this.outputOptions.getDetails()) {
            case SUMMARY: {
                return Optional.empty();
            }
            case FLAT: {
                return Optional.of(new FlatPrintingListener(out, colorPalette));
            }
            case TREE: {
                return Optional.of(new TreePrintingListener(out, colorPalette, theme));
            }
            case VERBOSE: {
                return Optional.of(new VerboseTreePrintingListener(out, colorPalette, 16, theme));
            }
            case TESTFEED: {
                return Optional.of(new TestFeedPrintingListener(out, colorPalette));
            }
        }
        return Optional.empty();
    }

    private ColorPalette getColorPalette() {
        if (this.outputOptions.isAnsiColorOutputDisabled()) {
            return ColorPalette.NONE;
        }
        if (this.outputOptions.getColorPalettePath() != null) {
            return new ColorPalette(this.outputOptions.getColorPalettePath());
        }
        if (this.outputOptions.isSingleColorPalette()) {
            return ColorPalette.SINGLE_COLOR;
        }
        return ColorPalette.DEFAULT;
    }

    private Optional<TestExecutionListener> createXmlWritingListener(PrintWriter out, Optional<Path> reportsDir) {
        return reportsDir.map(it -> new LegacyXmlReportGeneratingListener(it, out));
    }

    private void printSummary(TestExecutionSummary summary, PrintWriter out) {
        if (EnumSet.of(Details.NONE, Details.SUMMARY, Details.TREE).contains((Object)this.outputOptions.getDetails())) {
            summary.printFailuresTo(out);
        }
        summary.printTo(out);
    }

    @FunctionalInterface
    public static interface Factory {
        public ConsoleTestExecutor create(TestDiscoveryOptions var1, TestConsoleOutputOptions var2);
    }
}

