/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestIdentifier;

class TreeNode {
    private final String caption;
    private final long creation;
    long duration;
    private String reason;
    private TestIdentifier identifier;
    private TestExecutionResult result;
    List<ReportEntry> reports = Collections.emptyList();
    List<TreeNode> children = Collections.emptyList();
    boolean visible;

    TreeNode(String caption) {
        this.caption = caption;
        this.creation = System.currentTimeMillis();
        this.visible = false;
    }

    TreeNode(TestIdentifier identifier) {
        this(identifier.getDisplayName());
        this.identifier = identifier;
        this.visible = true;
    }

    TreeNode(TestIdentifier identifier, String reason) {
        this(identifier);
        this.reason = reason;
    }

    TreeNode addChild(TreeNode node) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList<TreeNode>();
        }
        this.children.add(node);
        return this;
    }

    TreeNode addReportEntry(ReportEntry reportEntry) {
        if (this.reports == Collections.EMPTY_LIST) {
            this.reports = new ArrayList<ReportEntry>();
        }
        this.reports.add(reportEntry);
        return this;
    }

    TreeNode setResult(TestExecutionResult result) {
        this.result = result;
        this.duration = System.currentTimeMillis() - this.creation;
        return this;
    }

    public String caption() {
        return this.caption;
    }

    Optional<String> reason() {
        return Optional.ofNullable(this.reason);
    }

    Optional<TestExecutionResult> result() {
        return Optional.ofNullable(this.result);
    }

    Optional<TestIdentifier> identifier() {
        return Optional.ofNullable(this.identifier);
    }
}

