/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import org.junit.platform.commons.meta.API;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

@API(value=API.Usage.Internal)
enum Color {
    NONE(0),
    BLACK(30),
    RED(31),
    GREEN(32),
    YELLOW(33),
    BLUE(34),
    PURPLE(35),
    CYAN(36),
    WHITE(37);

    static Color SUCCESSFUL;
    static Color ABORTED;
    static Color FAILED;
    static Color SKIPPED;
    static Color CONTAINER;
    static Color TEST;
    static Color DYNAMIC;
    static Color REPORTED;
    private final String ansiString;

    static Color valueOf(TestExecutionResult result) {
        switch (result.getStatus()) {
            case SUCCESSFUL: {
                return SUCCESSFUL;
            }
            case ABORTED: {
                return ABORTED;
            }
            case FAILED: {
                return FAILED;
            }
        }
        return NONE;
    }

    static Color valueOf(TestIdentifier testIdentifier) {
        return testIdentifier.isContainer() ? CONTAINER : TEST;
    }

    private Color(int ansiCode) {
        this.ansiString = "\u001b[" + ansiCode + "m";
    }

    public String toString() {
        return this.ansiString;
    }

    static {
        SUCCESSFUL = GREEN;
        ABORTED = YELLOW;
        FAILED = RED;
        SKIPPED = PURPLE;
        CONTAINER = CYAN;
        TEST = BLUE;
        DYNAMIC = PURPLE;
        REPORTED = WHITE;
    }
}

