/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.junit.platform.joptsimple.ValueConversionException;
import org.junit.platform.joptsimple.ValueConverter;

class URIConverter
implements ValueConverter<URI> {
    URIConverter() {
    }

    @Override
    public URI convert(String value) {
        try {
            return new URI(value);
        }
        catch (URISyntaxException e) {
            String message = MessageFormat.format("Value [{0}] is not a valid URI", value);
            throw new ValueConversionException(message, e);
        }
    }

    @Override
    public Class<? extends URI> valueType() {
        return URI.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }
}

