/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.joptsimple.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.junit.platform.joptsimple.ValueConversionException;
import org.junit.platform.joptsimple.ValueConverter;
import org.junit.platform.joptsimple.internal.Messages;

public class InetAddressConverter
implements ValueConverter<InetAddress> {
    @Override
    public InetAddress convert(String value) {
        try {
            return InetAddress.getByName(value);
        }
        catch (UnknownHostException e) {
            throw new ValueConversionException(this.message(value));
        }
    }

    @Override
    public Class<InetAddress> valueType() {
        return InetAddress.class;
    }

    @Override
    public String valuePattern() {
        return null;
    }

    private String message(String value) {
        return Messages.message(Locale.getDefault(), "org.junit.platform.joptsimple.ExceptionMessages", InetAddressConverter.class, "message", value);
    }
}

