/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.function.Consumer;
import org.junit.platform.commons.meta.API;
import org.junit.platform.console.tasks.ConsoleTask;

@API(value=API.Usage.Internal)
public class ConsoleTaskExecutor {
    private final PrintStream out;
    private final PrintStream err;

    public ConsoleTaskExecutor(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeTask(ConsoleTask task, Consumer<PrintWriter> helpPrinter) {
        PrintWriter outWriter = new PrintWriter(this.out);
        try {
            int n = task.execute(outWriter);
            return n;
        }
        catch (Exception e) {
            this.printException(e);
            this.printHelp(helpPrinter, outWriter);
            int n = -1;
            return n;
        }
        finally {
            outWriter.flush();
        }
    }

    private void printHelp(Consumer<PrintWriter> helpPrinter, PrintWriter outWriter) {
        try {
            helpPrinter.accept(outWriter);
        }
        catch (Exception e) {
            this.err.print("Exception occurred while printing help: ");
            this.printException(e);
        }
    }

    private void printException(Exception exception) {
        exception.printStackTrace(this.err);
        this.err.println();
    }
}

