/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class ColoredPrintingTestListener
implements TestExecutionListener {
    private static final Pattern LINE_START_PATTERN = Pattern.compile("(?m)^");
    static final String INDENTATION = "             ";
    private final PrintWriter out;
    private final boolean disableAnsiColors;

    ColoredPrintingTestListener(PrintWriter out, boolean disableAnsiColors) {
        this.out = out;
        this.disableAnsiColors = disableAnsiColors;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.out.printf("Test execution started. Number of static tests: %d%n", testPlan.countTestIdentifiers(TestIdentifier::isTest));
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.out.println("Test execution finished.");
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Color.BLUE, "Test registered:", testIdentifier);
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.printlnTestDescriptor(Color.YELLOW, "Skipped:", testIdentifier);
        this.printlnMessage(Color.YELLOW, "Reason", reason);
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        this.printlnTestDescriptor(Color.NONE, "Started:", testIdentifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        Color color = this.determineColor(testExecutionResult.getStatus());
        this.printlnTestDescriptor(color, "Finished:", testIdentifier);
        testExecutionResult.getThrowable().ifPresent(t -> this.printlnException(color, (Throwable)t));
    }

    public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
        this.printlnTestDescriptor(Color.PURPLE, "Reported:", testIdentifier);
        this.printlnMessage(Color.PURPLE, "Reported values", entry.toString());
    }

    private Color determineColor(TestExecutionResult.Status status) {
        switch (status) {
            case SUCCESSFUL: {
                return Color.GREEN;
            }
            case ABORTED: {
                return Color.YELLOW;
            }
            case FAILED: {
                return Color.RED;
            }
        }
        return Color.NONE;
    }

    private void printlnTestDescriptor(Color color, String message, TestIdentifier testIdentifier) {
        this.println(color, "%-10s   %s (%s)", message, testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    private void printlnException(Color color, Throwable throwable) {
        this.printlnMessage(color, "Exception", ExceptionUtils.readStackTrace((Throwable)throwable));
    }

    private void printlnMessage(Color color, String message, String detail) {
        this.println(color, "             => " + message + ": %s", ColoredPrintingTestListener.indented(detail));
    }

    private void println(Color color, String format, Object ... args) {
        this.println(color, String.format(format, args));
    }

    private void println(Color color, String message) {
        if (this.disableAnsiColors) {
            this.out.println(message);
        } else {
            this.out.println((Object)((Object)color) + message + (Object)((Object)Color.NONE));
        }
    }

    private static String indented(String message) {
        return LINE_START_PATTERN.matcher(message).replaceAll(INDENTATION).trim();
    }

    static enum Color {
        NONE(0),
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        PURPLE(35),
        CYAN(36),
        WHITE(37);

        private final int ansiCode;

        private Color(int ansiCode) {
            this.ansiCode = ansiCode;
        }

        public String toString() {
            return "\u001b[" + this.ansiCode + "m";
        }
    }
}

