/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.URIConverter;
import org.junit.platform.joptsimple.OptionParser;
import org.junit.platform.joptsimple.OptionSet;
import org.junit.platform.joptsimple.OptionSpec;
import org.junit.platform.joptsimple.util.PathConverter;
import org.junit.platform.joptsimple.util.PathProperties;

class AvailableOptions {
    private final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> help = this.parser.acceptsAll(Arrays.asList("h", "help"), "Display help information.");
    private final OptionSpec<Void> disableAnsiColors = this.parser.accepts("disable-ansi-colors", "Disable ANSI colors in output (not supported by all terminals).");
    private final OptionSpec<Void> hideDetails = this.parser.accepts("hide-details", "Hide details while tests are being executed. Only show the summary and test failures.");
    private final OptionSpec<Path> additionalClasspathEntries = this.parser.acceptsAll(Arrays.asList("cp", "classpath", "class-path"), "Provide additional classpath entries -- for example, for adding engines and their dependencies. This option can be repeated.").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0])).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("path1" + File.pathSeparator + "path2" + File.pathSeparator + "...");
    private final OptionSpec<Path> reportsDir = this.parser.accepts("reports-dir", "Enable report output into a specified local directory (will be created if it does not exist).").withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
    private final OptionSpec<Path> selectedClasspathEntries = this.parser.acceptsAll(Arrays.asList("scan-class-path", "scan-classpath"), "Scan entire classpath or explicit classpath roots.").withOptionalArg().withValuesConvertedBy(new PathConverter(new PathProperties[0])).withValuesSeparatedBy(File.pathSeparatorChar).describedAs("path1" + File.pathSeparator + "path2" + File.pathSeparator + "...");
    private final OptionSpec<URI> selectedUris = this.parser.acceptsAll(Arrays.asList("u", "select-uri"), "Select a URI for test discovery. This option can be repeated.").withRequiredArg().withValuesConvertedBy(new URIConverter());
    private final OptionSpec<String> selectedFiles = this.parser.acceptsAll(Arrays.asList("f", "select-file"), "Select a file for test discovery. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> selectedDirectories = this.parser.acceptsAll(Arrays.asList("d", "select-directory"), "Select a directory for test discovery. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> selectedPackages = this.parser.acceptsAll(Arrays.asList("p", "select-package"), "Select a package for test discovery. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> selectedClasses = this.parser.acceptsAll(Arrays.asList("c", "select-class"), "Select a class for test discovery. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> selectedMethods = this.parser.acceptsAll(Arrays.asList("m", "select-method"), "Select a method for test discovery. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> selectedClasspathResources = this.parser.acceptsAll(Arrays.asList("r", "select-resource"), "Select a classpath resource for test discovery. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> includeClassNamePattern = this.parser.acceptsAll(Arrays.asList("n", "include-classname"), "Provide a regular expression to include only classes whose fully qualified names match. To avoid loading classes unnecessarily, the default pattern only includes class names that end with \"Test\" or \"Tests\". When this option is repeated, all patterns will be combined using OR semantics.").withRequiredArg().defaultsTo("^.*Tests?$", (String[])new String[0]);
    private final OptionSpec<String> includePackage = this.parser.accepts("include-package", "Provide a package to be included in the test run. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> excludePackage = this.parser.accepts("exclude-package", "Provide a package to be excluded from the test run. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> includeTag = this.parser.acceptsAll(Arrays.asList("t", "include-tag"), "Provide a tag to be included in the test run. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> excludeTag = this.parser.acceptsAll(Arrays.asList("T", "exclude-tag"), "Provide a tag to be excluded from the test run. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> includeEngine = this.parser.acceptsAll(Arrays.asList("e", "include-engine"), "Provide the ID of an engine to be included in the test run. This option can be repeated.").withRequiredArg();
    private final OptionSpec<String> excludeEngine = this.parser.acceptsAll(Arrays.asList("E", "exclude-engine"), "Provide the ID of an engine to be excluded from the test run. This option can be repeated.").withRequiredArg();

    AvailableOptions() {
    }

    OptionParser getParser() {
        return this.parser;
    }

    CommandLineOptions toCommandLineOptions(OptionSet detectedOptions) {
        CommandLineOptions result = new CommandLineOptions();
        result.setDisplayHelp(detectedOptions.has(this.help));
        result.setAnsiColorOutputDisabled(detectedOptions.has(this.disableAnsiColors));
        result.setHideDetails(detectedOptions.has(this.hideDetails));
        result.setAdditionalClasspathEntries(detectedOptions.valuesOf(this.additionalClasspathEntries));
        result.setReportsDir(detectedOptions.valueOf(this.reportsDir));
        result.setScanClasspath(detectedOptions.has(this.selectedClasspathEntries));
        result.setSelectedClasspathEntries(detectedOptions.valuesOf(this.selectedClasspathEntries));
        result.setSelectedUris(detectedOptions.valuesOf(this.selectedUris));
        result.setSelectedFiles(detectedOptions.valuesOf(this.selectedFiles));
        result.setSelectedDirectories(detectedOptions.valuesOf(this.selectedDirectories));
        result.setSelectedPackages(detectedOptions.valuesOf(this.selectedPackages));
        result.setSelectedClasses(detectedOptions.valuesOf(this.selectedClasses));
        result.setSelectedMethods(detectedOptions.valuesOf(this.selectedMethods));
        result.setSelectedClasspathResources(detectedOptions.valuesOf(this.selectedClasspathResources));
        result.setIncludedClassNamePatterns(detectedOptions.valuesOf(this.includeClassNamePattern));
        result.setIncludedPackages(detectedOptions.valuesOf(this.includePackage));
        result.setExcludedPackages(detectedOptions.valuesOf(this.excludePackage));
        result.setIncludedTags(detectedOptions.valuesOf(this.includeTag));
        result.setExcludedTags(detectedOptions.valuesOf(this.excludeTag));
        result.setIncludedEngines(detectedOptions.valuesOf(this.includeEngine));
        result.setExcludedEngines(detectedOptions.valuesOf(this.excludeEngine));
        return result;
    }
}

