/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.io.PrintWriter;
import org.junit.platform.commons.meta.API;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;
import org.junit.platform.console.options.JOptSimpleCommandLineOptionsParser;
import org.junit.platform.console.tasks.ConsoleTask;
import org.junit.platform.console.tasks.ConsoleTaskExecutor;
import org.junit.platform.console.tasks.DisplayHelpTask;
import org.junit.platform.console.tasks.ExecuteTestsTask;

@API(value=API.Usage.Maintained)
public class ConsoleLauncher {
    private final CommandLineOptionsParser commandLineOptionsParser;
    private final ConsoleTaskExecutor consoleTaskExecutor;

    @API(value=API.Usage.Maintained)
    public static void main(String ... args) {
        ConsoleLauncher consoleLauncher = new ConsoleLauncher(new JOptSimpleCommandLineOptionsParser(), new ConsoleTaskExecutor(System.out, System.err));
        int exitCode = consoleLauncher.execute(args);
        System.exit(exitCode);
    }

    ConsoleLauncher(CommandLineOptionsParser commandLineOptionsParser, ConsoleTaskExecutor consoleTaskExecutor) {
        this.commandLineOptionsParser = commandLineOptionsParser;
        this.consoleTaskExecutor = consoleTaskExecutor;
    }

    int execute(String ... args) {
        CommandLineOptions options = this.commandLineOptionsParser.parse(args);
        ConsoleTask task = this.determineTask(options);
        return this.consoleTaskExecutor.executeTask(task, this::displayHelp);
    }

    private ConsoleTask determineTask(CommandLineOptions options) {
        if (options.isDisplayHelp()) {
            return new DisplayHelpTask(this.commandLineOptionsParser);
        }
        return new ExecuteTestsTask(options);
    }

    void displayHelp(PrintWriter out) {
        new DisplayHelpTask(this.commandLineOptionsParser).execute(out);
    }
}

