/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.tasks.ClasspathEntriesParser;
import org.junit.platform.console.tasks.ColoredPrintingTestListener;
import org.junit.platform.console.tasks.ConsoleTask;
import org.junit.platform.console.tasks.CustomContextClassLoaderExecutor;
import org.junit.platform.console.tasks.DiscoveryRequestCreator;
import org.junit.platform.console.tasks.XmlReportsWritingListener;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

@API(value=API.Usage.Internal)
public class ExecuteTestsTask
implements ConsoleTask {
    private final CommandLineOptions options;
    private final Supplier<Launcher> launcherSupplier;

    public ExecuteTestsTask(CommandLineOptions options) {
        this(options, LauncherFactory::create);
    }

    ExecuteTestsTask(CommandLineOptions options, Supplier<Launcher> launcherSupplier) {
        this.options = options;
        this.launcherSupplier = launcherSupplier;
    }

    @Override
    public int execute(PrintWriter out) throws Exception {
        return new CustomContextClassLoaderExecutor(this.createCustomClassLoader()).invoke(() -> this.executeTests(out));
    }

    private int executeTests(PrintWriter out) {
        Launcher launcher = this.launcherSupplier.get();
        SummaryGeneratingListener summaryListener = this.registerListeners(out, launcher);
        LauncherDiscoveryRequest discoveryRequest = new DiscoveryRequestCreator().toDiscoveryRequest(this.options);
        launcher.execute(discoveryRequest);
        TestExecutionSummary summary = summaryListener.getSummary();
        this.printSummary(summary, out);
        return this.computeExitCode(summary);
    }

    private Optional<ClassLoader> createCustomClassLoader() {
        List<String> additionalClasspathEntries = this.options.getAdditionalClasspathEntries();
        if (!additionalClasspathEntries.isEmpty()) {
            URL[] urls = new ClasspathEntriesParser().toURLs(additionalClasspathEntries);
            ClassLoader parentClassLoader = ReflectionUtils.getDefaultClassLoader();
            URLClassLoader customClassLoader = URLClassLoader.newInstance(urls, parentClassLoader);
            return Optional.of(customClassLoader);
        }
        return Optional.empty();
    }

    private SummaryGeneratingListener registerListeners(PrintWriter out, Launcher launcher) {
        SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
        if (!this.options.isHideDetails()) {
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new ColoredPrintingTestListener(out, this.options.isAnsiColorOutputDisabled())});
        }
        if (this.options.getXmlReportsDir().isPresent()) {
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{new XmlReportsWritingListener(this.options.getXmlReportsDir().get(), out)});
        }
        return summaryListener;
    }

    private void printSummary(TestExecutionSummary summary, PrintWriter out) {
        if (this.options.isHideDetails()) {
            summary.printFailuresTo(out);
        }
        summary.printTo(out);
    }

    private int computeExitCode(TestExecutionSummary summary) {
        if (summary.getTestsFailedCount() == 0L) {
            return 0;
        }
        return 1;
    }
}

