/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.tasks.ClasspathEntriesParser;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.ClassFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

class DiscoveryRequestCreator {
    DiscoveryRequestCreator() {
    }

    LauncherDiscoveryRequest toDiscoveryRequest(CommandLineOptions options) {
        LauncherDiscoveryRequestBuilder requestBuilder = this.createRequestBuilder(options);
        this.addFilters(requestBuilder, options);
        return requestBuilder.build();
    }

    private LauncherDiscoveryRequestBuilder createRequestBuilder(CommandLineOptions options) {
        if (options.isRunAllTests()) {
            return this.createBuilderForAllTests(options);
        }
        return this.createNameBasedBuilder(options);
    }

    private LauncherDiscoveryRequestBuilder createBuilderForAllTests(CommandLineOptions options) {
        Set<File> rootDirectoriesToScan = this.determineClasspathRootDirectories(options);
        return LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(rootDirectoriesToScan));
    }

    private Set<File> determineClasspathRootDirectories(CommandLineOptions options) {
        if (options.getArguments().isEmpty()) {
            LinkedHashSet<File> rootDirs = new LinkedHashSet<File>(ReflectionUtils.getAllClasspathRootDirectories());
            if (!options.getAdditionalClasspathEntries().isEmpty()) {
                rootDirs.addAll(new ClasspathEntriesParser().toDirectories(options.getAdditionalClasspathEntries()));
            }
            return rootDirs;
        }
        return options.getArguments().stream().map(File::new).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private LauncherDiscoveryRequestBuilder createNameBasedBuilder(CommandLineOptions options) {
        Preconditions.notEmpty(options.getArguments(), (String)"No arguments were supplied to the ConsoleLauncher");
        return LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectNames(options.getArguments()));
    }

    private void addFilters(LauncherDiscoveryRequestBuilder requestBuilder, CommandLineOptions options) {
        options.getIncludeClassNamePattern().ifPresent(pattern -> requestBuilder.filters(new Filter[]{ClassFilter.includeClassNamePattern((String)pattern)}));
        if (!options.getIncludedTags().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.includeTags(options.getIncludedTags())});
        }
        if (!options.getExcludedTags().isEmpty()) {
            requestBuilder.filters(new Filter[]{TagFilter.excludeTags(options.getExcludedTags())});
        }
        if (!options.getIncludedEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.includeEngines(options.getIncludedEngines())});
        }
        if (!options.getExcludedEngines().isEmpty()) {
            requestBuilder.filters(new Filter[]{EngineFilter.excludeEngines(options.getExcludedEngines())});
        }
    }
}

