/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.JUnitException;

class ClasspathEntriesParser {
    private static final String PATH_SEPARATOR_PATTERN = Pattern.quote(File.pathSeparator);

    ClasspathEntriesParser() {
    }

    URL[] toURLs(List<String> additionalClasspathEntries) {
        return (URL[])this.split(additionalClasspathEntries).map(this::toURL).toArray(URL[]::new);
    }

    Set<File> toDirectories(List<String> additionalClasspathEntries) {
        return this.split(additionalClasspathEntries).filter(File::isDirectory).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Stream<File> split(List<String> additionalClasspathEntries) {
        return additionalClasspathEntries.stream().map(entry -> entry.split(PATH_SEPARATOR_PATTERN)).flatMap(Arrays::stream).map(File::new);
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (Exception ex) {
            throw new JUnitException("Invalid classpath entry: " + file, (Throwable)ex);
        }
    }
}

