/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import joptsimple.BuiltinHelpFormatter;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.meta.API;
import org.junit.platform.console.options.AvailableOptions;
import org.junit.platform.console.options.CommandLineOptions;
import org.junit.platform.console.options.CommandLineOptionsParser;

@API(value=API.Usage.Internal)
public class JOptSimpleCommandLineOptionsParser
implements CommandLineOptionsParser {
    @Override
    public CommandLineOptions parse(String ... arguments) {
        AvailableOptions availableOptions = this.getAvailableOptions();
        OptionParser parser = availableOptions.getParser();
        OptionSet detectedOptions = parser.parse(arguments);
        return availableOptions.toCommandLineOptions(detectedOptions);
    }

    @Override
    public void printHelp(Writer writer) {
        OptionParser optionParser = this.getAvailableOptions().getParser();
        optionParser.formatHelpWith((HelpFormatter)new OrderPreservingHelpFormatter());
        try {
            optionParser.printHelpOn(writer);
        }
        catch (IOException e) {
            throw new JUnitException("Error printing help", (Throwable)e);
        }
    }

    private AvailableOptions getAvailableOptions() {
        return new AvailableOptions();
    }

    private static final class OrderPreservingHelpFormatter
    extends BuiltinHelpFormatter {
        private OrderPreservingHelpFormatter() {
            super(100, 4);
        }

        public String format(Map<String, ? extends OptionDescriptor> options) {
            this.addRows(new LinkedHashSet<OptionDescriptor>(options.values()));
            return this.formattedHelpOutput();
        }
    }
}

