/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.options;

import java.util.Arrays;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.junit.platform.console.options.CommandLineOptions;

class AvailableOptions {
    private final OptionParser parser = new OptionParser();
    private final OptionSpec<Void> help;
    private final OptionSpec<Void> disableAnsiColors;
    private final OptionSpec<Void> runAllTests = this.parser.acceptsAll(Arrays.asList("a", "all"), "Run all tests");
    private final OptionSpec<Void> hideDetails;
    private final OptionSpec<String> includeClassNamePattern;
    private final OptionSpec<String> includeTag;
    private final OptionSpec<String> excludeTag;
    private final OptionSpec<String> includeEngine;
    private final OptionSpec<String> excludeEngine;
    private final OptionSpec<String> additionalClasspathEntries = this.parser.acceptsAll(Arrays.asList("p", "classpath"), "Provide additional classpath entries -- for example, for adding engines and their dependencies.").withRequiredArg();
    private final OptionSpec<String> xmlReportsDir;
    private final OptionSpec<String> arguments;

    AvailableOptions() {
        this.includeClassNamePattern = this.parser.acceptsAll(Arrays.asList("n", "include-classname"), "Provide a regular expression to include only classes whose fully qualified names match. By default any class name is accepted, and thus all classes with tests are included.").withRequiredArg();
        this.includeTag = this.parser.acceptsAll(Arrays.asList("t", "include-tag"), "Provide a tag to be included in the test run. This option can be repeated.").withRequiredArg();
        this.excludeTag = this.parser.acceptsAll(Arrays.asList("T", "exclude-tag"), "Provide a tag to be excluded from the test run. This option can be repeated.").withRequiredArg();
        this.includeEngine = this.parser.acceptsAll(Arrays.asList("e", "include-engine"), "Provide the ID of an engine to be included in the test run. This option can be repeated.").withRequiredArg();
        this.excludeEngine = this.parser.acceptsAll(Arrays.asList("E", "exclude-engine"), "Provide the ID of an engine to be excluded from the test run. This option can be repeated.").withRequiredArg();
        this.xmlReportsDir = this.parser.acceptsAll(Arrays.asList("r", "xml-reports-dir"), "Enable XML report output into a specified local directory (will be created if it does not exist).").withRequiredArg();
        this.disableAnsiColors = this.parser.acceptsAll(Arrays.asList("C", "disable-ansi-colors"), "Disable colored output (not supported by all terminals).");
        this.hideDetails = this.parser.acceptsAll(Arrays.asList("D", "hide-details"), "Hide details while tests are being executed. Only show the summary and test failures.");
        this.help = this.parser.acceptsAll(Arrays.asList("h", "help"), "Display help information.");
        this.arguments = this.parser.nonOptions("Test classes, methods, or packages to execute. If --all|-a has been provided, arguments can list all classpath roots that should be considered for test scanning, or none if the full classpath should be scanned.");
    }

    OptionParser getParser() {
        return this.parser;
    }

    CommandLineOptions toCommandLineOptions(OptionSet detectedOptions) {
        CommandLineOptions result = new CommandLineOptions();
        result.setDisplayHelp(detectedOptions.has(this.help));
        result.setAnsiColorOutputDisabled(detectedOptions.has(this.disableAnsiColors));
        result.setRunAllTests(detectedOptions.has(this.runAllTests));
        result.setHideDetails(detectedOptions.has(this.hideDetails));
        result.setIncludeClassNamePattern((String)detectedOptions.valueOf(this.includeClassNamePattern));
        result.setIncludedTags(detectedOptions.valuesOf(this.includeTag));
        result.setExcludedTags(detectedOptions.valuesOf(this.excludeTag));
        result.setIncludedEngines(detectedOptions.valuesOf(this.includeEngine));
        result.setExcludedEngines(detectedOptions.valuesOf(this.excludeEngine));
        result.setAdditionalClasspathEntries(detectedOptions.valuesOf(this.additionalClasspathEntries));
        result.setXmlReportsDir((String)detectedOptions.valueOf(this.xmlReportsDir));
        result.setArguments(detectedOptions.valuesOf(this.arguments));
        return result;
    }
}

