/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opentest4j.reporting.tooling.spi.htmlreport.Section;
import org.opentest4j.reporting.tooling.spi.htmlreport.Subsections;

final class ImmutableSubsections
implements Subsections {
    private final List<Section> content;

    private ImmutableSubsections(List<Section> content) {
        this.content = content;
    }

    @Override
    public List<Section> getContent() {
        return this.content;
    }

    public final ImmutableSubsections withContent(Section ... elements) {
        List<Section> newValue = ImmutableSubsections.createUnmodifiableList(false, ImmutableSubsections.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSubsections(newValue);
    }

    public final ImmutableSubsections withContent(Iterable<? extends Section> elements) {
        if (this.content == elements) {
            return this;
        }
        List<Section> newValue = ImmutableSubsections.createUnmodifiableList(false, ImmutableSubsections.createSafeList(elements, true, false));
        return new ImmutableSubsections(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSubsections && this.equalsByValue((ImmutableSubsections)another);
    }

    private boolean equalsByValue(ImmutableSubsections another) {
        return this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return "Subsections{content=" + this.content + "}";
    }

    public static Subsections copyOf(Subsections instance) {
        if (instance instanceof ImmutableSubsections) {
            return (ImmutableSubsections)instance;
        }
        return new Subsections.Builder().addAllContent((Iterable)instance.getContent()).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static class Builder {
        private List<Section> content = new ArrayList<Section>();

        public Builder() {
            if (!(this instanceof Subsections.Builder)) {
                throw new UnsupportedOperationException("Use: new Subsections.Builder()");
            }
        }

        public final Subsections.Builder addContent(Section element) {
            this.content.add(Objects.requireNonNull(element, "content element"));
            return (Subsections.Builder)this;
        }

        public final Subsections.Builder addContent(Section ... elements) {
            for (Section element : elements) {
                this.content.add(Objects.requireNonNull(element, "content element"));
            }
            return (Subsections.Builder)this;
        }

        public final Subsections.Builder content(Iterable<? extends Section> elements) {
            this.content.clear();
            return this.addAllContent(elements);
        }

        public final Subsections.Builder addAllContent(Iterable<? extends Section> elements) {
            for (Section section : elements) {
                this.content.add(Objects.requireNonNull(section, "content element"));
            }
            return (Subsections.Builder)this;
        }

        public Subsections build() {
            return new ImmutableSubsections(ImmutableSubsections.createUnmodifiableList(true, this.content));
        }
    }
}

