/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opentest4j.reporting.tooling.spi.htmlreport.Block;
import org.opentest4j.reporting.tooling.spi.htmlreport.Section;

final class ImmutableSection
implements Section {
    private final String title;
    private final String metaInfo;
    private final List<Block<?>> blocks;
    private final int order;

    private ImmutableSection(Builder builder) {
        this.title = builder.title;
        this.metaInfo = builder.metaInfo;
        this.blocks = ImmutableSection.createUnmodifiableList(true, builder.blocks);
        this.order = builder.orderIsSet() ? builder.order : Section.super.getOrder();
    }

    private ImmutableSection(String title, String metaInfo, List<Block<?>> blocks, int order) {
        this.title = title;
        this.metaInfo = metaInfo;
        this.blocks = blocks;
        this.order = order;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Optional<String> getMetaInfo() {
        return Optional.ofNullable(this.metaInfo);
    }

    @Override
    public List<Block<?>> getBlocks() {
        return this.blocks;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public final ImmutableSection withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableSection(newValue, this.metaInfo, this.blocks, this.order);
    }

    public final ImmutableSection withMetaInfo(String value) {
        String newValue = Objects.requireNonNull(value, "metaInfo");
        if (Objects.equals(this.metaInfo, newValue)) {
            return this;
        }
        return new ImmutableSection(this.title, newValue, this.blocks, this.order);
    }

    public final ImmutableSection withMetaInfo(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.metaInfo, value)) {
            return this;
        }
        return new ImmutableSection(this.title, value, this.blocks, this.order);
    }

    @SafeVarargs
    public final ImmutableSection withBlocks(Block<?> ... elements) {
        List<Block<?>> newValue = ImmutableSection.createUnmodifiableList(false, ImmutableSection.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSection(this.title, this.metaInfo, newValue, this.order);
    }

    public final ImmutableSection withBlocks(Iterable<? extends Block<?>> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block<?>> newValue = ImmutableSection.createUnmodifiableList(false, ImmutableSection.createSafeList(elements, true, false));
        return new ImmutableSection(this.title, this.metaInfo, newValue, this.order);
    }

    public final ImmutableSection withOrder(int value) {
        if (this.order == value) {
            return this;
        }
        return new ImmutableSection(this.title, this.metaInfo, this.blocks, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSection && this.equalsByValue((ImmutableSection)another);
    }

    private boolean equalsByValue(ImmutableSection another) {
        return this.title.equals(another.title) && Objects.equals(this.metaInfo, another.metaInfo) && this.blocks.equals(another.blocks) && this.order == another.order;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.metaInfo);
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.order;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Section{");
        builder.append("title=").append(this.title);
        if (this.metaInfo != null) {
            builder.append(", ");
            builder.append("metaInfo=").append(this.metaInfo);
        }
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("order=").append(this.order);
        return builder.append("}").toString();
    }

    public static Section copyOf(Section instance) {
        if (instance instanceof ImmutableSection) {
            return (ImmutableSection)instance;
        }
        return new Section.Builder().title(instance.getTitle()).metaInfo(instance.getMetaInfo()).addAllBlocks(instance.getBlocks()).order(instance.getOrder()).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_ORDER = 1L;
        private long initBits = 1L;
        private long optBits;
        private String title;
        private String metaInfo;
        private List<Block<?>> blocks = new ArrayList();
        private int order;

        public Builder() {
            if (!(this instanceof Section.Builder)) {
                throw new UnsupportedOperationException("Use: new Section.Builder()");
            }
        }

        public final Section.Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Section.Builder)this;
        }

        public final Section.Builder metaInfo(String metaInfo) {
            this.metaInfo = Objects.requireNonNull(metaInfo, "metaInfo");
            return (Section.Builder)this;
        }

        public final Section.Builder metaInfo(Optional<String> metaInfo) {
            this.metaInfo = metaInfo.orElse(null);
            return (Section.Builder)this;
        }

        public final Section.Builder addBlock(Block<?> element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return (Section.Builder)this;
        }

        @SafeVarargs
        public final Section.Builder addBlocks(Block<?> ... elements) {
            for (Block<?> element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return (Section.Builder)this;
        }

        public final Section.Builder blocks(Iterable<? extends Block<?>> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Section.Builder addAllBlocks(Iterable<? extends Block<?>> elements) {
            for (Block<?> element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return (Section.Builder)this;
        }

        public final Section.Builder order(int order) {
            this.order = order;
            this.optBits |= 1L;
            return (Section.Builder)this;
        }

        public Section build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSection(this);
        }

        private boolean orderIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build Section, some of required attributes are not set " + attributes;
        }
    }
}

