/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.ArrayList;
import java.util.Objects;
import org.opentest4j.reporting.tooling.spi.htmlreport.Paragraph;

final class ImmutableParagraph
implements Paragraph {
    private final String content;

    private ImmutableParagraph(String content) {
        this.content = content;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public final ImmutableParagraph withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableParagraph(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParagraph && this.equalsByValue((ImmutableParagraph)another);
    }

    private boolean equalsByValue(ImmutableParagraph another) {
        return this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return "Paragraph{content=" + this.content + "}";
    }

    public static Paragraph copyOf(Paragraph instance) {
        if (instance instanceof ImmutableParagraph) {
            return (ImmutableParagraph)instance;
        }
        return new Paragraph.Builder().content((String)instance.getContent()).build();
    }

    public static class Builder {
        private static final long INIT_BIT_CONTENT = 1L;
        private long initBits = 1L;
        private String content;

        public Builder() {
            if (!(this instanceof Paragraph.Builder)) {
                throw new UnsupportedOperationException("Use: new Paragraph.Builder()");
            }
        }

        public final Paragraph.Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Paragraph.Builder)this;
        }

        public Paragraph build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParagraph(this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build Paragraph, some of required attributes are not set " + attributes;
        }
    }
}

