/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opentest4j.reporting.tooling.spi.htmlreport.Labels;

final class ImmutableLabels
implements Labels {
    private final List<String> content;

    private ImmutableLabels(List<String> content) {
        this.content = content;
    }

    @Override
    public List<String> getContent() {
        return this.content;
    }

    public final ImmutableLabels withContent(String ... elements) {
        List<String> newValue = ImmutableLabels.createUnmodifiableList(false, ImmutableLabels.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLabels(newValue);
    }

    public final ImmutableLabels withContent(Iterable<String> elements) {
        if (this.content == elements) {
            return this;
        }
        List<String> newValue = ImmutableLabels.createUnmodifiableList(false, ImmutableLabels.createSafeList(elements, true, false));
        return new ImmutableLabels(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabels && this.equalsByValue((ImmutableLabels)another);
    }

    private boolean equalsByValue(ImmutableLabels another) {
        return this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return "Labels{content=" + this.content + "}";
    }

    public static Labels copyOf(Labels instance) {
        if (instance instanceof ImmutableLabels) {
            return (ImmutableLabels)instance;
        }
        return new Labels.Builder().addAllContent((Iterable)instance.getContent()).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static class Builder {
        private List<String> content = new ArrayList<String>();

        public Builder() {
            if (!(this instanceof Labels.Builder)) {
                throw new UnsupportedOperationException("Use: new Labels.Builder()");
            }
        }

        public final Labels.Builder addContent(String element) {
            this.content.add(Objects.requireNonNull(element, "content element"));
            return (Labels.Builder)this;
        }

        public final Labels.Builder addContent(String ... elements) {
            for (String element : elements) {
                this.content.add(Objects.requireNonNull(element, "content element"));
            }
            return (Labels.Builder)this;
        }

        public final Labels.Builder content(Iterable<String> elements) {
            this.content.clear();
            return this.addAllContent(elements);
        }

        public final Labels.Builder addAllContent(Iterable<String> elements) {
            for (String element : elements) {
                this.content.add(Objects.requireNonNull(element, "content element"));
            }
            return (Labels.Builder)this;
        }

        public Labels build() {
            return new ImmutableLabels(ImmutableLabels.createUnmodifiableList(true, this.content));
        }
    }
}

