/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opentest4j.reporting.tooling.spi.htmlreport.KeyValuePairs;

final class ImmutableKeyValuePairs
implements KeyValuePairs {
    private final Map<String, String> content;

    private ImmutableKeyValuePairs(Map<String, String> content) {
        this.content = content;
    }

    @Override
    public Map<String, String> getContent() {
        return this.content;
    }

    public final ImmutableKeyValuePairs withContent(Map<String, ? extends String> entries) {
        if (this.content == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableKeyValuePairs.createUnmodifiableMap(true, false, entries);
        return new ImmutableKeyValuePairs(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyValuePairs && this.equalsByValue((ImmutableKeyValuePairs)another);
    }

    private boolean equalsByValue(ImmutableKeyValuePairs another) {
        return this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return "KeyValuePairs{content=" + this.content + "}";
    }

    public static KeyValuePairs copyOf(KeyValuePairs instance) {
        if (instance instanceof ImmutableKeyValuePairs) {
            return (ImmutableKeyValuePairs)instance;
        }
        return new KeyValuePairs.Builder().putAllContent((Map)instance.getContent()).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static class Builder {
        private Map<String, String> content = new LinkedHashMap<String, String>();

        public Builder() {
            if (!(this instanceof KeyValuePairs.Builder)) {
                throw new UnsupportedOperationException("Use: new KeyValuePairs.Builder()");
            }
        }

        public final KeyValuePairs.Builder putContent(String key, String value) {
            this.content.put(Objects.requireNonNull(key, "content key"), Objects.requireNonNull(value, value == null ? "content value for key: " + key : null));
            return (KeyValuePairs.Builder)this;
        }

        public final KeyValuePairs.Builder putContent(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.content.put(Objects.requireNonNull(k, "content key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "content value for key: " + k : null));
            return (KeyValuePairs.Builder)this;
        }

        public final KeyValuePairs.Builder content(Map<String, ? extends String> entries) {
            this.content.clear();
            return this.putAllContent(entries);
        }

        public final KeyValuePairs.Builder putAllContent(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.content.put(Objects.requireNonNull(k, "content key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "content value for key: " + k : null));
            }
            return (KeyValuePairs.Builder)this;
        }

        public KeyValuePairs build() {
            return new ImmutableKeyValuePairs(ImmutableKeyValuePairs.createUnmodifiableMap(false, false, this.content));
        }
    }
}

