/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.function.Predicate;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.suite.api.Suite;

final class IsSuiteClass
implements Predicate<Class<?>> {
    private final DiscoveryIssueReporter.Condition<Class<?>> condition;

    IsSuiteClass(DiscoveryIssueReporter issueReporter) {
        this.condition = IsSuiteClass.isNotPrivateUnlessAbstract(issueReporter).and(IsSuiteClass.isNotLocal(issueReporter)).and(IsSuiteClass.isNotInner(issueReporter));
    }

    @Override
    public boolean test(Class<?> testClass) {
        return this.hasSuiteAnnotation(testClass) && this.condition.check(testClass) && ModifierSupport.isNotAbstract(testClass);
    }

    private boolean hasSuiteAnnotation(Class<?> testClass) {
        return AnnotationSupport.isAnnotated(testClass, Suite.class);
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotPrivateUnlessAbstract(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> ModifierSupport.isNotPrivate(testClass) || ModifierSupport.isAbstract(testClass), testClass -> IsSuiteClass.createIssue(testClass, "must not be private."));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotLocal(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !testClass.isLocalClass(), testClass -> IsSuiteClass.createIssue(testClass, "must not be a local class."));
    }

    private static DiscoveryIssueReporter.Condition<Class<?>> isNotInner(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(testClass -> !ReflectionUtils.isInnerClass(testClass), testClass -> IsSuiteClass.createIssue(testClass, "must not be an inner class. Did you forget to declare it static?"));
    }

    private static DiscoveryIssue createIssue(Class<?> testClass, String detailMessage) {
        String message = "@Suite class '%s' %s It will not be executed.".formatted(testClass.getName(), detailMessage);
        return DiscoveryIssue.builder(DiscoveryIssue.Severity.WARNING, message).source(ClassSource.from(testClass)).build();
    }
}

