/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.jfr;

import org.apiguardian.api.API;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.jfr.FlightRecordingDiscoveryListener;
import org.junit.platform.launcher.jfr.FlightRecordingExecutionListener;

@API(status=API.Status.INTERNAL, since="6.0")
public class JfrUtils {
    public static void registerListeners(Launcher launcher) {
        if (JfrUtils.isJfrAvailable()) {
            launcher.registerLauncherDiscoveryListeners(new FlightRecordingDiscoveryListener());
            launcher.registerTestExecutionListeners(new FlightRecordingExecutionListener());
        }
    }

    private static boolean isJfrAvailable() {
        return System.getProperty("org.graalvm.nativeimage.imagecode") == null && ReflectionSupport.tryToLoadClass("jdk.jfr.FlightRecorder").toOptional().isPresent();
    }

    private JfrUtils() {
    }
}

