/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.OutputDirectoryCreator;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.ClasspathAlignmentChecker;
import org.junit.platform.launcher.core.DiscoveryIssueNotifier;
import org.junit.platform.launcher.core.ExecutionListenerAdapter;
import org.junit.platform.launcher.core.InternalTestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.LauncherPhase;
import org.junit.platform.launcher.core.ListenerRegistry;
import org.junit.platform.launcher.core.OutcomeDelayingEngineExecutionListener;
import org.junit.platform.launcher.core.StackTracePruningEngineExecutionListener;
import org.junit.platform.launcher.core.StreamInterceptingTestExecutionListener;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class EngineExecutionOrchestrator {
    private final ListenerRegistry<TestExecutionListener> listenerRegistry;

    public EngineExecutionOrchestrator() {
        this(ListenerRegistry.forTestExecutionListeners());
    }

    EngineExecutionOrchestrator(ListenerRegistry<TestExecutionListener> listenerRegistry) {
        this.listenerRegistry = listenerRegistry;
    }

    void execute(InternalTestPlan internalTestPlan, NamespacedHierarchicalStore<Namespace> requestLevelStore, Collection<? extends TestExecutionListener> listeners, CancellationToken cancellationToken) {
        ConfigurationParameters configurationParameters = internalTestPlan.getConfigurationParameters();
        ListenerRegistry<TestExecutionListener> testExecutionListenerListeners = this.buildListenerRegistryForExecution(listeners);
        this.withInterceptedStreams(configurationParameters, testExecutionListenerListeners, testExecutionListener -> this.execute(internalTestPlan, EngineExecutionListener.NOOP, (TestExecutionListener)testExecutionListener, requestLevelStore, cancellationToken));
    }

    @API(status=API.Status.INTERNAL, since="1.9", consumers={"org.junit.platform.suite.engine"})
    public void execute(LauncherDiscoveryResult discoveryResult, EngineExecutionListener engineExecutionListener, TestExecutionListener testExecutionListener, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        Preconditions.notNull(discoveryResult, "discoveryResult must not be null");
        Preconditions.notNull(engineExecutionListener, "engineExecutionListener must not be null");
        Preconditions.notNull(testExecutionListener, "testExecutionListener must not be null");
        Preconditions.notNull(requestLevelStore, "requestLevelStore must not be null");
        Preconditions.notNull(cancellationToken, "cancellationToken must not be null");
        InternalTestPlan internalTestPlan = InternalTestPlan.from(discoveryResult);
        this.execute(internalTestPlan, engineExecutionListener, testExecutionListener, requestLevelStore, cancellationToken);
    }

    private void execute(InternalTestPlan internalTestPlan, EngineExecutionListener parentEngineExecutionListener, TestExecutionListener testExecutionListener, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        internalTestPlan.markStarted();
        TestPlan testPlan = internalTestPlan.getDelegate();
        LauncherDiscoveryResult discoveryResult = internalTestPlan.getDiscoveryResult();
        testExecutionListener.testPlanExecutionStarted(testPlan);
        if (this.isDryRun(internalTestPlan).booleanValue()) {
            this.dryRun(testPlan, testExecutionListener);
        } else {
            this.execute(discoveryResult, EngineExecutionOrchestrator.buildEngineExecutionListener(parentEngineExecutionListener, testExecutionListener, testPlan), requestLevelStore, cancellationToken);
        }
        testExecutionListener.testPlanExecutionFinished(testPlan);
    }

    private Boolean isDryRun(InternalTestPlan internalTestPlan) {
        return internalTestPlan.getConfigurationParameters().getBoolean("junit.platform.execution.dryRun.enabled").orElse(false);
    }

    private void dryRun(TestPlan testPlan, final TestExecutionListener listener) {
        testPlan.accept(new TestPlan.Visitor(){
            final /* synthetic */ EngineExecutionOrchestrator this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void preVisitContainer(TestIdentifier testIdentifier) {
                listener.executionStarted(testIdentifier);
            }

            @Override
            public void visit(TestIdentifier testIdentifier) {
                if (!testIdentifier.isContainer()) {
                    listener.executionSkipped(testIdentifier, "JUnit Platform dry-run mode is enabled");
                }
            }

            @Override
            public void postVisitContainer(TestIdentifier testIdentifier) {
                listener.executionFinished(testIdentifier, TestExecutionResult.successful());
            }
        });
    }

    private static EngineExecutionListener buildEngineExecutionListener(EngineExecutionListener parentEngineExecutionListener, TestExecutionListener testExecutionListener, TestPlan testPlan) {
        ListenerRegistry<EngineExecutionListener> engineExecutionListenerRegistry = ListenerRegistry.forEngineExecutionListeners();
        engineExecutionListenerRegistry.add(new ExecutionListenerAdapter(testPlan, testExecutionListener));
        engineExecutionListenerRegistry.add(parentEngineExecutionListener);
        return engineExecutionListenerRegistry.getCompositeListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withInterceptedStreams(ConfigurationParameters configurationParameters, ListenerRegistry<TestExecutionListener> listenerRegistry, Consumer<TestExecutionListener> action) {
        TestExecutionListener testExecutionListener = listenerRegistry.getCompositeListener();
        Optional<StreamInterceptingTestExecutionListener> streamInterceptingTestExecutionListener = StreamInterceptingTestExecutionListener.create(configurationParameters, testExecutionListener::reportingEntryPublished);
        streamInterceptingTestExecutionListener.ifPresent(listenerRegistry::add);
        try {
            action.accept(listenerRegistry.getCompositeListener());
        }
        finally {
            streamInterceptingTestExecutionListener.ifPresent(StreamInterceptingTestExecutionListener::unregister);
        }
    }

    @API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit"})
    public void execute(LauncherDiscoveryResult discoveryResult, EngineExecutionListener engineExecutionListener, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        Preconditions.notNull(discoveryResult, "discoveryResult must not be null");
        Preconditions.notNull(engineExecutionListener, "engineExecutionListener must not be null");
        ConfigurationParameters configurationParameters = discoveryResult.getConfigurationParameters();
        EngineExecutionListener listener = EngineExecutionOrchestrator.selectExecutionListener(engineExecutionListener, configurationParameters);
        for (TestEngine testEngine : discoveryResult.getTestEngines()) {
            this.failOrExecuteEngine(discoveryResult, listener, testEngine, requestLevelStore, cancellationToken);
        }
    }

    private static EngineExecutionListener selectExecutionListener(EngineExecutionListener engineExecutionListener, ConfigurationParameters configurationParameters) {
        boolean stackTracePruningEnabled = configurationParameters.getBoolean("junit.platform.stacktrace.pruning.enabled").orElse(true);
        if (stackTracePruningEnabled) {
            return new StackTracePruningEngineExecutionListener(engineExecutionListener);
        }
        return engineExecutionListener;
    }

    private void failOrExecuteEngine(LauncherDiscoveryResult discoveryResult, EngineExecutionListener listener, TestEngine testEngine, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        LauncherDiscoveryResult.EngineResultInfo engineDiscoveryResult = discoveryResult.getEngineResult(testEngine);
        DiscoveryIssueNotifier discoveryIssueNotifier = EngineExecutionOrchestrator.shouldReportDiscoveryIssues(discoveryResult) ? engineDiscoveryResult.getDiscoveryIssueNotifier() : DiscoveryIssueNotifier.NO_ISSUES;
        TestDescriptor engineDescriptor = engineDiscoveryResult.getRootDescriptor();
        Throwable failure = engineDiscoveryResult.getCause().orElseGet(() -> discoveryIssueNotifier.createExceptionForCriticalIssues(testEngine));
        if (failure != null) {
            listener.executionStarted(engineDescriptor);
            if (engineDiscoveryResult.getCause().isPresent()) {
                discoveryIssueNotifier.logCriticalIssues(testEngine);
            }
            discoveryIssueNotifier.logNonCriticalIssues(testEngine);
            listener.executionFinished(engineDescriptor, TestExecutionResult.failed(failure));
        } else if (cancellationToken.isCancellationRequested()) {
            listener.executionStarted(engineDescriptor);
            engineDescriptor.getChildren().forEach(child -> listener.executionSkipped((TestDescriptor)child, "Execution cancelled"));
            listener.executionFinished(engineDescriptor, TestExecutionResult.aborted(null));
        } else {
            this.executeEngine(engineDescriptor, listener, discoveryResult.getConfigurationParameters(), testEngine, discoveryResult.getOutputDirectoryCreator(), discoveryIssueNotifier, requestLevelStore, cancellationToken);
        }
    }

    private static boolean shouldReportDiscoveryIssues(LauncherDiscoveryResult discoveryResult) {
        ConfigurationParameters configurationParameters = discoveryResult.getConfigurationParameters();
        return LauncherPhase.getDiscoveryIssueFailurePhase(configurationParameters).orElse(LauncherPhase.EXECUTION) == LauncherPhase.EXECUTION;
    }

    private ListenerRegistry<TestExecutionListener> buildListenerRegistryForExecution(Collection<? extends TestExecutionListener> listeners) {
        if (listeners.isEmpty()) {
            return this.listenerRegistry;
        }
        return ListenerRegistry.copyOf(this.listenerRegistry).addAll(listeners);
    }

    private void executeEngine(TestDescriptor engineDescriptor, EngineExecutionListener listener, ConfigurationParameters configurationParameters, TestEngine testEngine, OutputDirectoryCreator outputDirectoryCreator, DiscoveryIssueNotifier discoveryIssueNotifier, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        OutcomeDelayingEngineExecutionListener delayingListener = new OutcomeDelayingEngineExecutionListener(listener, engineDescriptor);
        try {
            testEngine.execute(ExecutionRequest.create(engineDescriptor, delayingListener, configurationParameters, outputDirectoryCreator, requestLevelStore, cancellationToken));
            discoveryIssueNotifier.logNonCriticalIssues(testEngine);
            delayingListener.reportEngineOutcome();
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            JUnitException cause = null;
            if (throwable instanceof LinkageError) {
                LinkageError error = (LinkageError)throwable;
                cause = ClasspathAlignmentChecker.check(error).orElse(null);
            }
            if (cause == null) {
                String message = "TestEngine with ID '%s' failed to execute tests".formatted(testEngine.getId());
                cause = new JUnitException(message, throwable);
            }
            delayingListener.reportEngineStartIfNecessary();
            discoveryIssueNotifier.logNonCriticalIssues(testEngine);
            delayingListener.reportEngineFailure(cause);
        }
    }
}

