/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.locks.Lock;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

class SingleLock
implements ResourceLock {
    private final List<ExclusiveResource> resources;
    private final Lock lock;

    SingleLock(ExclusiveResource resource, Lock lock) {
        this.resources = List.of(resource);
        this.lock = lock;
    }

    @Override
    public List<ExclusiveResource> getResources() {
        return this.resources;
    }

    Lock getLock() {
        return this.lock;
    }

    @Override
    public boolean tryAcquire() {
        return this.lock.tryLock();
    }

    @Override
    public ResourceLock acquire() throws InterruptedException {
        ForkJoinPool.managedBlock(new SingleLockManagedBlocker());
        return this;
    }

    @Override
    public void release() {
        this.lock.unlock();
    }

    @Override
    public boolean isExclusive() {
        return this.resources.get(0).getLockMode() == ExclusiveResource.LockMode.READ_WRITE;
    }

    public String toString() {
        return new ToStringBuilder(this).append("resource", CollectionUtils.getOnlyElement(this.resources)).toString();
    }

    private class SingleLockManagedBlocker
    implements ForkJoinPool.ManagedBlocker {
        private volatile boolean acquired;

        private SingleLockManagedBlocker() {
        }

        @Override
        public boolean block() throws InterruptedException {
            if (!this.acquired) {
                SingleLock.this.lock.lockInterruptibly();
                this.acquired = true;
            }
            return true;
        }

        @Override
        public boolean isReleasable() {
            return this.acquired || (this.acquired = SingleLock.this.lock.tryLock());
        }
    }
}

