/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.support.hierarchical.DelegatingFuture;

abstract class BlockingAwareFuture<T>
extends DelegatingFuture<T> {
    BlockingAwareFuture(Future<T> delegate) {
        super(delegate);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.delegate.isDone()) {
            return (T)this.delegate.get();
        }
        return (T)this.handleSafely(this.delegate::get);
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.delegate.isDone()) {
            return (T)this.delegate.get();
        }
        return (T)this.handleSafely(() -> this.delegate.get(timeout, unit));
    }

    private T handleSafely(Callable<T> callable) {
        try {
            return this.handle(callable);
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsUncheckedException(e);
        }
    }

    protected abstract T handle(Callable<T> var1) throws Exception;
}

