/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.io.ResourceFilter;
import org.junit.platform.commons.support.ResourceSupport;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.discovery.ResourceUtils;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class ResourceContainerSelectorResolver
implements SelectorResolver {
    private final ResourceFilter resourceFilter;

    ResourceContainerSelectorResolver(ResourceFilter resourceFilter, Predicate<String> packageFilter) {
        this.resourceFilter = ResourceFilter.of(ResourceUtils.packageName(packageFilter).and(resourceFilter::match));
    }

    @Override
    public SelectorResolver.Resolution resolve(ClasspathRootSelector selector, SelectorResolver.Context context) {
        return this.resourceSelectors(ResourceSupport.findAllResourcesInClasspathRoot(selector.getClasspathRoot(), this.resourceFilter));
    }

    @Override
    public SelectorResolver.Resolution resolve(ModuleSelector selector, SelectorResolver.Context context) {
        if (selector.getModule().isPresent()) {
            Module module = selector.getModule().get();
            return this.resourceSelectors(ResourceSupport.findAllResourcesInModule(module, this.resourceFilter));
        }
        return this.resourceSelectors(ResourceSupport.findAllResourcesInModule(selector.getModuleName(), this.resourceFilter));
    }

    @Override
    public SelectorResolver.Resolution resolve(PackageSelector selector, SelectorResolver.Context context) {
        return this.resourceSelectors(ResourceSupport.findAllResourcesInPackage(selector.getPackageName(), this.resourceFilter));
    }

    private SelectorResolver.Resolution resourceSelectors(List<Resource> resources) {
        Set selectors = resources.stream().collect(Collectors.groupingBy(Resource::getName)).values().stream().map(LinkedHashSet::new).map(DiscoverySelectors::selectClasspathResourceByName).collect(Collectors.toSet());
        if (selectors.isEmpty()) {
            return SelectorResolver.Resolution.unresolved();
        }
        return SelectorResolver.Resolution.selectors(selectors);
    }
}

