/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.FilePosition;

@API(status=API.Status.STABLE, since="1.0")
public final class ClassSource
implements TestSource {
    private static final long serialVersionUID = 1L;
    @API(status=API.Status.STABLE, since="1.8")
    public static final String CLASS_SCHEME = "class";
    private final String className;
    private final @Nullable FilePosition filePosition;
    private @Nullable Class<?> javaClass;

    public static ClassSource from(String className) {
        return new ClassSource(className);
    }

    public static ClassSource from(String className, @Nullable FilePosition filePosition) {
        return new ClassSource(className, filePosition);
    }

    public static ClassSource from(Class<?> javaClass) {
        return new ClassSource(javaClass);
    }

    public static ClassSource from(Class<?> javaClass, FilePosition filePosition) {
        return new ClassSource(javaClass, filePosition);
    }

    @API(status=API.Status.STABLE, since="1.8")
    public static ClassSource from(URI uri) {
        Preconditions.notNull(uri, "URI must not be null");
        Preconditions.condition(CLASS_SCHEME.equals(uri.getScheme()), () -> "URI [" + String.valueOf(uri) + "] must have [class] scheme");
        String className = uri.getSchemeSpecificPart();
        FilePosition filePosition = null;
        int indexOfQuery = className.indexOf(63);
        if (indexOfQuery >= 0) {
            filePosition = FilePosition.fromQuery(className.substring(indexOfQuery + 1)).orElse(null);
            className = className.substring(0, indexOfQuery);
        }
        return ClassSource.from(className, filePosition);
    }

    private ClassSource(String className) {
        this(className, null);
    }

    private ClassSource(String className, @Nullable FilePosition filePosition) {
        this.className = Preconditions.notBlank(className, "Class name must not be null or blank");
        this.filePosition = filePosition;
    }

    private ClassSource(Class<?> javaClass) {
        this(javaClass, null);
    }

    private ClassSource(Class<?> javaClass, @Nullable FilePosition filePosition) {
        this.javaClass = Preconditions.notNull(javaClass, "Class must not be null");
        this.className = this.javaClass.getName();
        this.filePosition = filePosition;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            this.javaClass = ReflectionSupport.tryToLoadClass(this.className).getNonNullOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
        return this.javaClass;
    }

    public Optional<FilePosition> getPosition() {
        return Optional.ofNullable(this.filePosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSource that = (ClassSource)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.filePosition, that.filePosition);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.filePosition);
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.className).append("filePosition", this.filePosition).toString();
    }
}

