/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.PackageNameFilter;

class ExcludePackageNameFilter
implements PackageNameFilter {
    private final List<String> packageNames;
    private final String patternDescription;

    ExcludePackageNameFilter(String ... packageNames) {
        Preconditions.notEmpty(packageNames, "packageNames must not be null or empty");
        Preconditions.containsNoNullElements(packageNames, "packageNames must not contain null elements");
        this.packageNames = Arrays.asList(packageNames);
        this.patternDescription = Arrays.stream(packageNames).collect(Collectors.joining("' OR '", "'", "'"));
    }

    @Override
    public FilterResult apply(String packageName) {
        return this.findMatchingName(packageName).map(matchedName -> FilterResult.excluded(this.formatExclusionReason(packageName, (String)matchedName))).orElseGet(() -> FilterResult.included(this.formatInclusionReason(packageName)));
    }

    private String formatInclusionReason(String packageName) {
        return "Package name [%s] does not match any excluded names: %s".formatted(packageName, this.patternDescription);
    }

    private String formatExclusionReason(String packageName, String matchedName) {
        return "Package name [%s] matches excluded name: '%s'".formatted(packageName, matchedName);
    }

    @Override
    public Predicate<String> toPredicate() {
        return packageName -> this.findMatchingName((String)packageName).isEmpty();
    }

    private Optional<String> findMatchingName(String packageName) {
        return this.packageNames.stream().filter(name -> name.equals(packageName) || packageName.startsWith(name + ".")).findAny();
    }

    public String toString() {
        return "%s that excludes packages whose names are either equal to or start with one of the following: %s".formatted(this.getClass().getSimpleName(), this.patternDescription);
    }
}

