/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParsers;
import org.junit.platform.engine.discovery.FilePosition;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;
import org.junit.platform.engine.discovery.NestedMethodSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(status=API.Status.STABLE, since="1.0")
public final class DiscoverySelectors {
    private DiscoverySelectors() {
    }

    public static UriSelector selectUri(String uri) {
        Preconditions.notBlank(uri, "URI must not be null or blank");
        try {
            return new UriSelector(new URI(uri));
        }
        catch (URISyntaxException ex) {
            throw new PreconditionViolationException("Failed to create a java.net.URI from: " + uri, ex);
        }
    }

    public static UriSelector selectUri(URI uri) {
        Preconditions.notNull(uri, "URI must not be null");
        return new UriSelector(uri);
    }

    public static FileSelector selectFile(String path) {
        return DiscoverySelectors.selectFile(path, null);
    }

    public static FileSelector selectFile(File file) {
        return DiscoverySelectors.selectFile(file, null);
    }

    public static FileSelector selectFile(String path, @Nullable FilePosition position) {
        Preconditions.notBlank(path, "File path must not be null or blank");
        return new FileSelector(path, position);
    }

    public static FileSelector selectFile(File file, @Nullable FilePosition position) {
        Preconditions.notNull(file, "File must not be null");
        Preconditions.condition(file.isFile(), () -> "The supplied java.io.File [%s] must represent an existing file".formatted(file));
        try {
            return new FileSelector(file.getCanonicalPath(), position);
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for file: " + String.valueOf(file), ex);
        }
    }

    public static DirectorySelector selectDirectory(String path) {
        Preconditions.notBlank(path, "Directory path must not be null or blank");
        return new DirectorySelector(path);
    }

    public static DirectorySelector selectDirectory(File directory) {
        Preconditions.notNull(directory, "Directory must not be null");
        Preconditions.condition(directory.isDirectory(), () -> "The supplied java.io.File [%s] must represent an existing directory".formatted(directory));
        try {
            return new DirectorySelector(directory.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for directory: " + String.valueOf(directory), ex);
        }
    }

    public static List<ClasspathRootSelector> selectClasspathRoots(Set<Path> classpathRoots) {
        Preconditions.notNull(classpathRoots, "classpathRoots must not be null");
        return classpathRoots.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri).map(ClasspathRootSelector::new).toList();
    }

    public static ClasspathResourceSelector selectClasspathResource(String classpathResourceName) {
        return DiscoverySelectors.selectClasspathResource(classpathResourceName, null);
    }

    public static ClasspathResourceSelector selectClasspathResource(String classpathResourceName, @Nullable FilePosition position) {
        Preconditions.notBlank(classpathResourceName, "classpath resource name must not be null or blank");
        return new ClasspathResourceSelector(classpathResourceName, position);
    }

    @API(status=API.Status.DEPRECATED, since="1.14")
    @Deprecated(since="1.14", forRemoval=true)
    public static ClasspathResourceSelector selectClasspathResource(Set<org.junit.platform.commons.support.Resource> classpathResources) {
        return DiscoverySelectors.selectClasspathResourceByName(classpathResources);
    }

    @API(status=API.Status.MAINTAINED, since="1.14")
    public static ClasspathResourceSelector selectClasspathResourceByName(Set<? extends Resource> classpathResources) {
        Preconditions.notEmpty(classpathResources, "classpath resources must not be null or empty");
        Preconditions.containsNoNullElements(classpathResources, "individual classpath resources must not be null");
        List<String> resourceNames = classpathResources.stream().map(Resource::getName).distinct().toList();
        Preconditions.condition(resourceNames.size() == 1, "all classpath resources must have the same name");
        Preconditions.notBlank(resourceNames.get(0), "classpath resource names must not be null or blank");
        return new ClasspathResourceSelector(classpathResources);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static ModuleSelector selectModule(String moduleName) {
        Preconditions.notBlank(moduleName, "Module name must not be null or blank");
        return new ModuleSelector(moduleName.strip());
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public static ModuleSelector selectModule(Module module) {
        Preconditions.notNull(module, "Module must not be null");
        Preconditions.condition(module.isNamed(), "Module must be named");
        return new ModuleSelector(module);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static List<ModuleSelector> selectModules(Set<String> moduleNames) {
        Preconditions.notNull(moduleNames, "Module names must not be null");
        Preconditions.containsNoNullElements(moduleNames, "Individual module name must not be null");
        return moduleNames.stream().map(DiscoverySelectors::selectModule).toList();
    }

    public static PackageSelector selectPackage(String packageName) {
        Preconditions.notNull(packageName, "Package name must not be null");
        Preconditions.condition(packageName.isEmpty() || !packageName.isBlank(), "Package name must not contain only whitespace");
        return new PackageSelector(packageName.strip());
    }

    public static ClassSelector selectClass(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return new ClassSelector(clazz);
    }

    public static ClassSelector selectClass(String className) {
        return DiscoverySelectors.selectClass(null, className);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static ClassSelector selectClass(@Nullable ClassLoader classLoader, String className) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        return new ClassSelector(classLoader, className);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static List<ClassSelector> selectClasses(Class<?> ... classes) {
        return DiscoverySelectors.selectClasses(List.of(classes));
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static List<ClassSelector> selectClasses(List<Class<?>> classes) {
        Preconditions.notNull(classes, "classes must not be null");
        Preconditions.containsNoNullElements(classes, "Individual classes must not be null");
        return classes.stream().distinct().map(DiscoverySelectors::selectClass).toList();
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static List<ClassSelector> selectClassesByName(String ... classNames) {
        return DiscoverySelectors.selectClassesByName(List.of(classNames));
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static List<ClassSelector> selectClassesByName(List<String> classNames) {
        return DiscoverySelectors.selectClassesByName(null, classNames);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static List<ClassSelector> selectClassesByName(@Nullable ClassLoader classLoader, String ... classNames) {
        return DiscoverySelectors.selectClassesByName(classLoader, List.of(classNames));
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public static List<ClassSelector> selectClassesByName(@Nullable ClassLoader classLoader, List<String> classNames) {
        Preconditions.notNull(classNames, "classNames must not be null");
        Preconditions.containsNoNullElements(classNames, "Individual class names must not be null");
        return classNames.stream().distinct().map(className -> DiscoverySelectors.selectClass(classLoader, className)).toList();
    }

    public static MethodSelector selectMethod(String fullyQualifiedMethodName) throws PreconditionViolationException {
        return DiscoverySelectors.selectMethod((ClassLoader)null, fullyQualifiedMethodName);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static MethodSelector selectMethod(@Nullable ClassLoader classLoader, String fullyQualifiedMethodName) throws PreconditionViolationException {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName(fullyQualifiedMethodName);
        return DiscoverySelectors.selectMethod(classLoader, methodParts[0], methodParts[1], methodParts[2]);
    }

    public static MethodSelector selectMethod(String className, String methodName) {
        return DiscoverySelectors.selectMethod((ClassLoader)null, className, methodName);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static MethodSelector selectMethod(@Nullable ClassLoader classLoader, String className, String methodName) {
        return DiscoverySelectors.selectMethod(classLoader, className, methodName, "");
    }

    public static MethodSelector selectMethod(String className, String methodName, String parameterTypeNames) {
        return DiscoverySelectors.selectMethod(null, className, methodName, parameterTypeNames);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static MethodSelector selectMethod(@Nullable ClassLoader classLoader, String className, String methodName, String parameterTypeNames) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypeNames, "Parameter type names must not be null");
        return new MethodSelector(classLoader, className, methodName, parameterTypeNames.strip());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName) {
        return DiscoverySelectors.selectMethod(javaClass, methodName, "");
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName, String parameterTypeNames) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypeNames, "Parameter type names must not be null");
        return new MethodSelector(javaClass, methodName, parameterTypeNames.strip());
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static MethodSelector selectMethod(String className, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Parameter types array must not contain null elements");
        return new MethodSelector(null, className, methodName, parameterTypes);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static MethodSelector selectMethod(Class<?> javaClass, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Parameter types array must not contain null elements");
        return new MethodSelector(javaClass, methodName, parameterTypes);
    }

    public static MethodSelector selectMethod(Class<?> javaClass, Method method) {
        Preconditions.notNull(javaClass, "Class must not be null");
        Preconditions.notNull(method, "Method must not be null");
        return new MethodSelector(javaClass, method);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedClassSelector selectNestedClass(List<Class<?>> enclosingClasses, Class<?> nestedClass) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        return new NestedClassSelector(enclosingClasses, nestedClass);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedClassSelector selectNestedClass(List<String> enclosingClassNames, String nestedClassName) {
        return DiscoverySelectors.selectNestedClass(null, enclosingClassNames, nestedClassName);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static NestedClassSelector selectNestedClass(@Nullable ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName) {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        return new NestedClassSelector(classLoader, enclosingClassNames, nestedClassName);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<String> enclosingClassNames, String nestedClassName, String methodName) {
        return DiscoverySelectors.selectNestedMethod(null, enclosingClassNames, nestedClassName, methodName);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static NestedMethodSelector selectNestedMethod(@Nullable ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName, String methodName) throws PreconditionViolationException {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return new NestedMethodSelector(classLoader, enclosingClassNames, nestedClassName, methodName, "");
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<String> enclosingClassNames, String nestedClassName, String methodName, String parameterTypeNames) {
        return DiscoverySelectors.selectNestedMethod(null, enclosingClassNames, nestedClassName, methodName, parameterTypeNames);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static NestedMethodSelector selectNestedMethod(@Nullable ClassLoader classLoader, List<String> enclosingClassNames, String nestedClassName, String methodName, String parameterTypeNames) {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypeNames, "Parameter types must not be null");
        return new NestedMethodSelector(classLoader, enclosingClassNames, nestedClassName, methodName, parameterTypeNames.strip());
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static NestedMethodSelector selectNestedMethod(List<String> enclosingClassNames, String nestedClassName, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notEmpty(enclosingClassNames, "Enclosing class names must not be null or empty");
        Preconditions.notBlank(nestedClassName, "Nested class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Parameter types array must not contain null elements");
        return new NestedMethodSelector(null, enclosingClassNames, nestedClassName, methodName, parameterTypes);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName) {
        return DiscoverySelectors.selectNestedMethod(enclosingClasses, nestedClass, methodName, "");
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, String parameterTypeNames) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypeNames, "Parameter types must not be null");
        return new NestedMethodSelector(enclosingClasses, nestedClass, methodName, parameterTypeNames.strip());
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Parameter types array must not contain null elements");
        return new NestedMethodSelector(enclosingClasses, nestedClass, methodName, parameterTypes);
    }

    @API(status=API.Status.STABLE, since="1.6")
    public static NestedMethodSelector selectNestedMethod(List<Class<?>> enclosingClasses, Class<?> nestedClass, Method method) {
        Preconditions.notEmpty(enclosingClasses, "Enclosing classes must not be null or empty");
        Preconditions.notNull(nestedClass, "Nested class must not be null");
        Preconditions.notNull(method, "Method must not be null");
        return new NestedMethodSelector(enclosingClasses, nestedClass, method);
    }

    public static UniqueIdSelector selectUniqueId(UniqueId uniqueId) {
        Preconditions.notNull(uniqueId, "UniqueId must not be null");
        return new UniqueIdSelector(uniqueId);
    }

    public static UniqueIdSelector selectUniqueId(String uniqueId) {
        Preconditions.notBlank(uniqueId, "Unique ID must not be null or blank");
        return new UniqueIdSelector(UniqueId.parse(uniqueId));
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static IterationSelector selectIteration(DiscoverySelector parentSelector, int ... iterationIndices) {
        Preconditions.notNull(parentSelector, "Parent selector must not be null");
        Preconditions.notEmpty(iterationIndices, "iteration indices must not be empty");
        return new IterationSelector(parentSelector, iterationIndices);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Optional<? extends DiscoverySelector> parse(String identifier) {
        return DiscoverySelectorIdentifierParsers.parse(identifier);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Optional<? extends DiscoverySelector> parse(DiscoverySelectorIdentifier identifier) {
        return DiscoverySelectorIdentifierParsers.parse(identifier);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Stream<? extends DiscoverySelector> parseAll(String ... identifiers) {
        return DiscoverySelectorIdentifierParsers.parseAll(identifiers);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public static Stream<? extends DiscoverySelector> parseAll(Collection<DiscoverySelectorIdentifier> identifiers) {
        return DiscoverySelectorIdentifierParsers.parseAll(identifiers);
    }
}

