/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CompositeFilter;
import org.junit.platform.engine.FilterResult;

@FunctionalInterface
@API(status=API.Status.STABLE, since="1.0")
public interface Filter<T> {
    @SafeVarargs
    public static <T> Filter<T> composeFilters(Filter<T> ... filters) {
        Preconditions.notNull(filters, "filters array must not be null");
        Preconditions.containsNoNullElements(filters, "individual filters must not be null");
        if (filters.length == 0) {
            return CompositeFilter.alwaysIncluded();
        }
        if (filters.length == 1) {
            return filters[0];
        }
        return new CompositeFilter<T>(Arrays.asList(filters));
    }

    public static <T> Filter<T> composeFilters(Collection<? extends Filter<T>> filters) {
        Preconditions.notNull(filters, "Filters must not be null");
        if (filters.isEmpty()) {
            return CompositeFilter.alwaysIncluded();
        }
        if (filters.size() == 1) {
            return CollectionUtils.getOnlyElement(filters);
        }
        return new CompositeFilter(filters);
    }

    @API(status=API.Status.DEPRECATED, since="6.0")
    @Deprecated(since="6.0", forRemoval=true)
    public static <T, V> Filter<T> adaptFilter(Filter<V> adaptee, Function<T, V> converter) {
        return input -> adaptee.apply(converter.apply(input));
    }

    public FilterResult apply(T var1);

    default public Predicate<T> toPredicate() {
        return object -> this.apply(object).included();
    }
}

