/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.platform.commons.JUnitException;

class SearchPathUtils {
    static final char PACKAGE_SEPARATOR_CHAR = '.';
    static final String PACKAGE_SEPARATOR_STRING = String.valueOf('.');
    private static final char FILE_NAME_EXTENSION_SEPARATOR_CHAR = '.';
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String SOURCE_FILE_SUFFIX = ".java";
    private static final String PACKAGE_INFO_FILE_NAME = "package-info";
    private static final String MODULE_INFO_FILE_NAME = "module-info";
    private static final boolean SOURCE_MODE = System.getProperty("jdk.launcher.sourcefile") != null;

    static boolean isResourceFile(Path file) {
        return !SearchPathUtils.isClassFile(file);
    }

    static boolean isClassOrSourceFile(Path file) {
        String fileName = file.getFileName().toString();
        return SearchPathUtils.isClassOrSourceFile(fileName) && !SearchPathUtils.isModuleInfoOrPackageInfo(fileName);
    }

    private static boolean isModuleInfoOrPackageInfo(String fileName) {
        String fileNameWithoutExtension = SearchPathUtils.removeExtension(fileName);
        return PACKAGE_INFO_FILE_NAME.equals(fileNameWithoutExtension) || MODULE_INFO_FILE_NAME.equals(fileNameWithoutExtension);
    }

    static String determineFullyQualifiedClassName(Path path) {
        String simpleClassName = SearchPathUtils.determineSimpleClassName(path);
        Path parent = path.getParent();
        return parent == null ? simpleClassName : SearchPathUtils.joinPathNamesWithPackageSeparator(parent.resolve(simpleClassName));
    }

    private static String joinPathNamesWithPackageSeparator(Path path) {
        return IntStream.range(0, path.getNameCount()).mapToObj(i2 -> path.getName(i2).toString()).collect(Collectors.joining(PACKAGE_SEPARATOR_STRING));
    }

    static String determineSimpleClassName(Path file) {
        return SearchPathUtils.removeExtension(file.getFileName().toString());
    }

    private static String removeExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            throw new JUnitException("Expected file name with file extension, but got: " + fileName);
        }
        return fileName.substring(0, lastDot);
    }

    private static boolean isClassOrSourceFile(String name) {
        return name.endsWith(CLASS_FILE_SUFFIX) || SOURCE_MODE && name.endsWith(SOURCE_FILE_SUFFIX);
    }

    private static boolean isClassFile(Path file) {
        return file.getFileName().toString().endsWith(CLASS_FILE_SUFFIX);
    }

    private SearchPathUtils() {
    }
}

