/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

final class QuoteUtils {
    private QuoteUtils() {
    }

    public static String quote(CharSequence text) {
        if (text.isEmpty()) {
            return "\"\"";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        for (int i2 = 0; i2 < text.length(); ++i2) {
            builder.append(QuoteUtils.escape(text.charAt(i2), true));
        }
        builder.append('\"');
        return builder.toString();
    }

    public static String quote(char ch) {
        return "'" + QuoteUtils.escape(ch, false) + "'";
    }

    private static String escape(char ch, boolean withinString) {
        return switch (ch) {
            case '\"' -> {
                if (withinString) {
                    yield "\\\"";
                }
                yield "\"";
            }
            case '\'' -> {
                if (withinString) {
                    yield "'";
                }
                yield "\\'";
            }
            case '\\' -> "\\\\";
            case '\b' -> "\\b";
            case '\f' -> "\\f";
            case '\t' -> "\\t";
            case '\r' -> "\\r";
            case '\n' -> "\\n";
            default -> String.valueOf(ch);
        };
    }
}

