/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.engine.execution.DefaultParameterContext;
import org.junit.jupiter.engine.execution.ExtensionContextSupplier;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.KotlinReflectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;

@API(status=API.Status.INTERNAL, since="5.9")
public class ParameterResolutionUtils {
    private static final Logger logger = LoggerFactory.getLogger(ParameterResolutionUtils.class);

    public static @Nullable Object[] resolveParameters(Method method, Optional<Object> target, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ParameterResolutionUtils.resolveParameters(method, target, Optional.empty(), __ -> extensionContext, extensionRegistry, KotlinReflectionUtils.isKotlinSuspendingFunction(method) ? KotlinReflectionUtils.getKotlinSuspendingFunctionParameters(method) : method.getParameters());
    }

    public static @Nullable Object[] resolveParameters(Executable executable, Optional<Object> target, Optional<Object> outerInstance, ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        return ParameterResolutionUtils.resolveParameters(executable, target, outerInstance, (TestInstantiationAwareExtension __) -> extensionContext, extensionRegistry);
    }

    public static @Nullable Object[] resolveParameters(Executable executable, Optional<Object> target, Optional<Object> outerInstance, ExtensionContextSupplier extensionContext, ExtensionRegistry extensionRegistry) {
        return ParameterResolutionUtils.resolveParameters(executable, target, outerInstance, extensionContext, extensionRegistry, executable.getParameters());
    }

    private static @Nullable Object[] resolveParameters(Executable executable, Optional<Object> target, Optional<Object> outerInstance, ExtensionContextSupplier extensionContext, ExtensionRegistry extensionRegistry, Parameter[] parameters) {
        Preconditions.notNull(target, "target must not be null");
        @Nullable Object[] values = new Object[parameters.length];
        int start = 0;
        if (outerInstance.isPresent()) {
            values[0] = outerInstance.get();
            start = 1;
        }
        for (int i2 = start; i2 < parameters.length; ++i2) {
            DefaultParameterContext parameterContext = new DefaultParameterContext(parameters[i2], i2, target);
            values[i2] = ParameterResolutionUtils.resolveParameter(parameterContext, executable, extensionContext, extensionRegistry);
        }
        return values;
    }

    private static @Nullable Object resolveParameter(ParameterContext parameterContext, Executable executable, ExtensionContextSupplier extensionContext, ExtensionRegistry extensionRegistry) {
        try {
            List<ParameterResolver> matchingResolvers = extensionRegistry.stream(ParameterResolver.class).filter(resolver -> resolver.supportsParameter(parameterContext, extensionContext.get((TestInstantiationAwareExtension)resolver))).toList();
            if (matchingResolvers.isEmpty()) {
                throw new ParameterResolutionException("No ParameterResolver registered for parameter [%s] in %s [%s].".formatted(parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString()));
            }
            if (matchingResolvers.size() > 1) {
                String resolvers = matchingResolvers.stream().map(StringUtils::defaultToString).collect(Collectors.joining(", "));
                throw new ParameterResolutionException("Discovered multiple competing ParameterResolvers for parameter [%s] in %s [%s]: %s".formatted(parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString(), resolvers));
            }
            ParameterResolver resolver2 = matchingResolvers.get(0);
            Object value = resolver2.resolveParameter(parameterContext, extensionContext.get(resolver2));
            ParameterResolutionUtils.validateResolvedType(parameterContext.getParameter(), value, executable, resolver2);
            logger.trace(() -> "ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in %s [%s].".formatted(resolver2.getClass().getName(), value != null ? value.getClass().getTypeName() : null, parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString()));
            return value;
        }
        catch (ParameterResolutionException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(throwable);
            Object message = "Failed to resolve parameter [%s] in %s [%s]".formatted(parameterContext.getParameter(), ParameterResolutionUtils.asLabel(executable), executable.toGenericString());
            if (StringUtils.isNotBlank(throwable.getMessage())) {
                message = (String)message + ": " + throwable.getMessage();
            }
            throw new ParameterResolutionException((String)message, throwable);
        }
    }

    private static void validateResolvedType(Parameter parameter, @Nullable Object value, Executable executable, ParameterResolver resolver) {
        Class<?> type = parameter.getType();
        if (!ReflectionUtils.isAssignableTo(value, type)) {
            String message = value == null && type.isPrimitive() ? "ParameterResolver [%s] resolved a null value for parameter [%s] in %s [%s], but a primitive of type [%s] is required.".formatted(resolver.getClass().getName(), parameter, ParameterResolutionUtils.asLabel(executable), executable.toGenericString(), type.getName()) : "ParameterResolver [%s] resolved a value of type [%s] for parameter [%s] in %s [%s], but a value assignment compatible with [%s] is required.".formatted(resolver.getClass().getName(), value != null ? value.getClass().getTypeName() : null, parameter, ParameterResolutionUtils.asLabel(executable), executable.toGenericString(), type.getTypeName());
            throw new ParameterResolutionException(message);
        }
    }

    private static String asLabel(Executable executable) {
        return executable instanceof Constructor ? "constructor" : "method";
    }

    private ParameterResolutionUtils() {
    }
}

