/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;

@API(status=API.Status.INTERNAL, since="5.0")
public class NamespaceAwareStore
implements ExtensionContext.Store {
    private final NamespacedHierarchicalStore<Namespace> valuesStore;
    private final Namespace namespace;

    public NamespaceAwareStore(NamespacedHierarchicalStore<Namespace> valuesStore, Namespace namespace) {
        this.valuesStore = valuesStore;
        this.namespace = namespace;
    }

    @Override
    public @Nullable Object get(Object key) {
        Preconditions.notNull(key, "key must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.get(this.namespace, key);
        return this.accessStore(action);
    }

    public <T> @Nullable T get(Object key, Class<T> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.get(this.namespace, key, requiredType);
        return (T)this.accessStore(action);
    }

    @Override
    public <K, V> @Nullable Object getOrComputeIfAbsent(K key, Function<? super K, ? extends V> defaultCreator) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.getOrComputeIfAbsent(this.namespace, key, defaultCreator);
        return this.accessStore(action);
    }

    @Override
    public <K, V> @Nullable V getOrComputeIfAbsent(K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.getOrComputeIfAbsent(this.namespace, key, defaultCreator, requiredType);
        return (V)this.accessStore(action);
    }

    @Override
    public <K, V> Object computeIfAbsent(K key, Function<? super K, ? extends V> defaultCreator) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Supplier<Object> action = () -> this.valuesStore.computeIfAbsent(this.namespace, key, defaultCreator);
        return this.accessStore(action);
    }

    @Override
    public <K, V> V computeIfAbsent(K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(defaultCreator, "defaultCreator function must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        Supplier<Object> action = () -> this.valuesStore.computeIfAbsent(this.namespace, key, defaultCreator, requiredType);
        return (V)this.accessStore(action);
    }

    @Override
    public void put(Object key, @Nullable Object value) {
        Preconditions.notNull(key, "key must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.put(this.namespace, key, value);
        this.accessStore(action);
    }

    @Override
    public @Nullable Object remove(Object key) {
        Preconditions.notNull(key, "key must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.remove(this.namespace, key);
        return this.accessStore(action);
    }

    public <T> @Nullable T remove(Object key, Class<T> requiredType) {
        Preconditions.notNull(key, "key must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        Supplier<@Nullable Object> action = () -> this.valuesStore.remove(this.namespace, key, requiredType);
        return (T)this.accessStore(action);
    }

    private <T> T accessStore(Supplier<T> action) {
        try {
            return action.get();
        }
        catch (NamespacedHierarchicalStoreException e) {
            throw new ExtensionContextException(e.getMessage(), e);
        }
    }
}

