/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ClassTemplateInvocationLifecycleMethod;
import org.junit.jupiter.engine.support.MethodReflectionUtils;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;

final class LifecycleMethodUtils {
    private LifecycleMethodUtils() {
    }

    static List<Method> findBeforeAllMethods(Class<?> testClass, boolean requireStatic, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckStatic(testClass, requireStatic, BeforeAll.class, HierarchyTraversalMode.TOP_DOWN, issueReporter);
    }

    static List<Method> findAfterAllMethods(Class<?> testClass, boolean requireStatic, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckStatic(testClass, requireStatic, AfterAll.class, HierarchyTraversalMode.BOTTOM_UP, issueReporter);
    }

    static List<Method> findBeforeEachMethods(Class<?> testClass, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckNonStatic(testClass, BeforeEach.class, HierarchyTraversalMode.TOP_DOWN, issueReporter);
    }

    static List<Method> findAfterEachMethods(Class<?> testClass, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckNonStatic(testClass, AfterEach.class, HierarchyTraversalMode.BOTTOM_UP, issueReporter);
    }

    static void validateNoClassTemplateInvocationLifecycleMethodsAreDeclared(Class<?> testClass, DiscoveryIssueReporter issueReporter) {
        LifecycleMethodUtils.findAllClassTemplateInvocationLifecycleMethods(testClass).forEach(method -> LifecycleMethodUtils.findClassTemplateInvocationLifecycleMethodAnnotation(method).ifPresent(annotation -> {
            String message = "@%s method '%s' must not be declared in test class '%s' because it is not annotated with @%s.".formatted(annotation.lifecycleMethodAnnotation().getSimpleName(), method.toGenericString(), testClass.getName(), annotation.classTemplateAnnotation().getSimpleName());
            issueReporter.reportIssue(LifecycleMethodUtils.createIssue(DiscoveryIssue.Severity.ERROR, message, method));
        }));
    }

    static void validateClassTemplateInvocationLifecycleMethodsAreDeclaredCorrectly(Class<?> testClass, boolean requireStatic, DiscoveryIssueReporter issueReporter) {
        LifecycleMethodUtils.findAllClassTemplateInvocationLifecycleMethods(testClass).forEach(LifecycleMethodUtils.isNotPrivateError(issueReporter).and(LifecycleMethodUtils.returnsPrimitiveVoid(issueReporter, LifecycleMethodUtils::classTemplateInvocationLifecycleMethodAnnotationName)).and(requireStatic ? LifecycleMethodUtils.isStatic(issueReporter, LifecycleMethodUtils::classTemplateInvocationLifecycleMethodAnnotationName) : DiscoveryIssueReporter.Condition.alwaysSatisfied()).toConsumer());
    }

    private static Stream<Method> findAllClassTemplateInvocationLifecycleMethods(Class<?> testClass) {
        Stream allMethods = Stream.concat(AnnotationSupport.findAnnotatedMethods(testClass, ClassTemplateInvocationLifecycleMethod.class, HierarchyTraversalMode.TOP_DOWN).stream(), AnnotationSupport.findAnnotatedMethods(testClass, ClassTemplateInvocationLifecycleMethod.class, HierarchyTraversalMode.BOTTOM_UP).stream());
        return allMethods.distinct();
    }

    private static List<Method> findMethodsAndCheckStatic(Class<?> testClass, boolean requireStatic, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode, DiscoveryIssueReporter issueReporter) {
        DiscoveryIssueReporter.Condition additionalCondition = requireStatic ? LifecycleMethodUtils.isStatic(issueReporter, __ -> annotationType.getSimpleName()) : DiscoveryIssueReporter.Condition.alwaysSatisfied();
        return LifecycleMethodUtils.findMethodsAndCheckVoidReturnType(testClass, annotationType, traversalMode, issueReporter, additionalCondition);
    }

    private static List<Method> findMethodsAndCheckNonStatic(Class<?> testClass, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode, DiscoveryIssueReporter issueReporter) {
        return LifecycleMethodUtils.findMethodsAndCheckVoidReturnType(testClass, annotationType, traversalMode, issueReporter, LifecycleMethodUtils.isNotStatic(issueReporter, __ -> annotationType.getSimpleName()));
    }

    private static List<Method> findMethodsAndCheckVoidReturnType(Class<?> testClass, Class<? extends Annotation> annotationType, HierarchyTraversalMode traversalMode, DiscoveryIssueReporter issueReporter, DiscoveryIssueReporter.Condition<? super Method> additionalCondition) {
        return AnnotationSupport.findAnnotatedMethods(testClass, annotationType, traversalMode).stream().peek(LifecycleMethodUtils.isNotPrivateWarning(issueReporter, annotationType::getSimpleName).toConsumer()).filter(LifecycleMethodUtils.returnsPrimitiveVoid(issueReporter, __ -> annotationType.getSimpleName()).and(additionalCondition).toPredicate()).toList();
    }

    private static DiscoveryIssueReporter.Condition<Method> isStatic(DiscoveryIssueReporter issueReporter, Function<Method, String> annotationNameProvider) {
        return issueReporter.createReportingCondition(ModifierSupport::isStatic, method -> {
            String message = "@%s method '%s' must be static unless the test class is annotated with @TestInstance(Lifecycle.PER_CLASS).".formatted(annotationNameProvider.apply((Method)method), method.toGenericString());
            return LifecycleMethodUtils.createIssue(DiscoveryIssue.Severity.ERROR, message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> isNotStatic(DiscoveryIssueReporter issueReporter, Function<Method, String> annotationNameProvider) {
        return issueReporter.createReportingCondition(ModifierSupport::isNotStatic, method -> {
            String message = "@%s method '%s' must not be static.".formatted(annotationNameProvider.apply((Method)method), method.toGenericString());
            return LifecycleMethodUtils.createIssue(DiscoveryIssue.Severity.ERROR, message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> isNotPrivateError(DiscoveryIssueReporter issueReporter) {
        return issueReporter.createReportingCondition(ModifierSupport::isNotPrivate, method -> {
            String message = "@%s method '%s' must not be private.".formatted(LifecycleMethodUtils.classTemplateInvocationLifecycleMethodAnnotationName(method), method.toGenericString());
            return LifecycleMethodUtils.createIssue(DiscoveryIssue.Severity.ERROR, message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> isNotPrivateWarning(DiscoveryIssueReporter issueReporter, Supplier<String> annotationNameProvider) {
        return issueReporter.createReportingCondition(ModifierSupport::isNotPrivate, method -> {
            String message = "@%s method '%s' should not be private. This will be disallowed in a future release.".formatted(annotationNameProvider.get(), method.toGenericString());
            return LifecycleMethodUtils.createIssue(DiscoveryIssue.Severity.WARNING, message, method);
        });
    }

    private static DiscoveryIssueReporter.Condition<Method> returnsPrimitiveVoid(DiscoveryIssueReporter issueReporter, Function<Method, String> annotationNameProvider) {
        return issueReporter.createReportingCondition(method -> MethodReflectionUtils.getReturnType(method) == Void.TYPE, method -> {
            String message = "@%s method '%s' must not return a value.".formatted(annotationNameProvider.apply((Method)method), method.toGenericString());
            return LifecycleMethodUtils.createIssue(DiscoveryIssue.Severity.ERROR, message, method);
        });
    }

    private static String classTemplateInvocationLifecycleMethodAnnotationName(Method method) {
        return LifecycleMethodUtils.findClassTemplateInvocationLifecycleMethodAnnotation(method).map(ClassTemplateInvocationLifecycleMethod::lifecycleMethodAnnotation).map(Class::getSimpleName).orElseGet(ClassTemplateInvocationLifecycleMethod.class::getSimpleName);
    }

    private static Optional<ClassTemplateInvocationLifecycleMethod> findClassTemplateInvocationLifecycleMethodAnnotation(Method method) {
        return AnnotationSupport.findAnnotation(method, ClassTemplateInvocationLifecycleMethod.class);
    }

    private static DiscoveryIssue createIssue(DiscoveryIssue.Severity severity, String message, Method method) {
        return DiscoveryIssue.builder(severity, message).source(MethodSource.from(method)).build();
    }
}

