/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.DisplayNameUtils;
import org.junit.jupiter.engine.execution.ExtensionContextSupplier;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class ClassTestDescriptor
extends ClassBasedTestDescriptor {
    public static final String SEGMENT_TYPE = "class";

    public ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, JupiterConfiguration configuration) {
        super(uniqueId, testClass, DisplayNameUtils.createDisplayNameSupplierForClass(testClass, configuration), configuration);
    }

    private ClassTestDescriptor(UniqueId uniqueId, Class<?> testClass, String displayName, JupiterConfiguration configuration) {
        super(uniqueId, testClass, displayName, configuration);
    }

    @Override
    protected ClassTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new ClassTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.getTestClass(), this.getDisplayName(), this.configuration);
    }

    @Override
    public Set<TestTag> getTags() {
        return new LinkedHashSet<TestTag>(this.classInfo.tags);
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return Collections.emptyList();
    }

    @Override
    Node.ExecutionMode getDefaultExecutionMode() {
        return ClassTestDescriptor.toExecutionMode(this.configuration.getDefaultClassesExecutionMode());
    }

    @Override
    protected TestInstances instantiateTestClass(JupiterEngineExecutionContext parentExecutionContext, ExtensionContextSupplier extensionContext, ExtensionRegistry registry, JupiterEngineExecutionContext context) {
        return this.instantiateTestClass(Optional.empty(), registry, extensionContext);
    }

    @Override
    public Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> getResourceLocksProviderEvaluator() {
        return provider -> provider.provideForClass(this.getTestClass());
    }
}

