/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.AbstractRepeatableAnnotationCondition;
import org.junit.jupiter.api.condition.EnabledIfSystemProperty;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.platform.commons.util.Preconditions;

class EnabledIfSystemPropertyCondition
extends AbstractRepeatableAnnotationCondition<EnabledIfSystemProperty> {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled("No @EnabledIfSystemProperty conditions resulting in 'disabled' execution encountered");

    EnabledIfSystemPropertyCondition() {
        super(EnabledIfSystemProperty.class);
    }

    @Override
    protected ConditionEvaluationResult getNoDisabledConditionsEncounteredResult() {
        return ENABLED;
    }

    @Override
    protected ConditionEvaluationResult evaluate(EnabledIfSystemProperty annotation) {
        String name = annotation.named().strip();
        String regex = annotation.matches();
        Preconditions.notBlank(name, () -> "The 'named' attribute must not be blank in " + String.valueOf(annotation));
        Preconditions.notBlank(regex, () -> "The 'matches' attribute must not be blank in " + String.valueOf(annotation));
        String actual = System.getProperty(name);
        if (actual == null) {
            return ConditionEvaluationResult.disabled("System property [%s] does not exist".formatted(name), annotation.disabledReason());
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.enabled("System property [%s] with value [%s] matches regular expression [%s]".formatted(name, actual, regex));
        }
        return ConditionEvaluationResult.disabled("System property [%s] with value [%s] does not match regular expression [%s]".formatted(name, actual, regex), annotation.disabledReason());
    }
}

