/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="5.3")
public class DynamicContainer
extends DynamicNode {
    private final @Nullable ExecutionMode childExecutionMode;
    private final Stream<? extends DynamicNode> children;

    public static DynamicContainer dynamicContainer(String displayName, Iterable<? extends DynamicNode> dynamicNodes) {
        return DynamicContainer.dynamicContainer(config -> ((Configuration)config.displayName(displayName)).children(dynamicNodes));
    }

    public static DynamicContainer dynamicContainer(String displayName, Stream<? extends DynamicNode> dynamicNodes) {
        return DynamicContainer.dynamicContainer(config -> ((Configuration)config.displayName(displayName)).children(dynamicNodes));
    }

    public static DynamicContainer dynamicContainer(String displayName, @Nullable URI testSourceUri, Stream<? extends DynamicNode> dynamicNodes) {
        return DynamicContainer.dynamicContainer(config -> ((Configuration)((Configuration)config.displayName(displayName)).testSourceUri(testSourceUri)).children(dynamicNodes));
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public static DynamicContainer dynamicContainer(Consumer<? super Configuration> configurer) {
        DefaultConfiguration configuration = new DefaultConfiguration();
        configurer.accept(configuration);
        return new DynamicContainer(configuration);
    }

    private DynamicContainer(DefaultConfiguration configuration) {
        super(configuration);
        this.children = Preconditions.notNull(configuration.children, "children must not be null");
        this.childExecutionMode = configuration.childExecutionMode;
    }

    public Stream<? extends DynamicNode> getChildren() {
        return this.children;
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public Optional<ExecutionMode> getChildExecutionMode() {
        return Optional.ofNullable(this.childExecutionMode);
    }

    static final class DefaultConfiguration
    extends DynamicNode.AbstractConfiguration<Configuration>
    implements Configuration {
        private @Nullable Stream<? extends DynamicNode> children;
        private @Nullable ExecutionMode childExecutionMode;

        DefaultConfiguration() {
        }

        @Override
        public Configuration childExecutionMode(ExecutionMode executionMode) {
            this.childExecutionMode = Preconditions.notNull(executionMode, "executionMode must not be null");
            return this;
        }

        @Override
        public Configuration children(Stream<? extends DynamicNode> children) {
            Preconditions.notNull(children, "children must not be null");
            Preconditions.condition(this.children == null, "children can only be set once");
            this.children = children;
            return this;
        }

        @Override
        protected Configuration self() {
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @API(status=API.Status.EXPERIMENTAL, since="6.1")
    public static interface Configuration
    extends DynamicNode.Configuration<Configuration> {
        public Configuration childExecutionMode(ExecutionMode var1);

        default public Configuration children(Iterable<? extends DynamicNode> children) {
            Preconditions.notNull(children, "children must not be null");
            return this.children(StreamSupport.stream(children.spliterator(), false));
        }

        default public Configuration children(DynamicNode ... children) {
            Preconditions.notNull(children, "children must not be null");
            Preconditions.containsNoNullElements(children, "children must not contain null elements");
            return this.children(List.of(children));
        }

        public Configuration children(Stream<? extends DynamicNode> var1);
    }
}

