/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.discovery;

import org.apiguardian.api.API;
import org.junit.platform.commons.support.scanning.ClassFilter;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageEngineDescriptor;
import org.junit.vintage.engine.discovery.ClassSelectorResolver;
import org.junit.vintage.engine.discovery.IsPotentialJUnit4TestClass;
import org.junit.vintage.engine.discovery.MethodSelectorResolver;
import org.junit.vintage.engine.discovery.RunnerTestDescriptorPostProcessor;

@API(status=API.Status.INTERNAL, since="4.12")
public class VintageDiscoverer {
    private static final IsPotentialJUnit4TestClass isPotentialJUnit4TestClass = new IsPotentialJUnit4TestClass();
    private static final EngineDiscoveryRequestResolver<TestDescriptor> resolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver(isPotentialJUnit4TestClass).addSelectorResolver(context -> new ClassSelectorResolver(ClassFilter.of(context.getClassNameFilter(), isPotentialJUnit4TestClass))).addSelectorResolver(new MethodSelectorResolver()).build();

    public VintageEngineDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId uniqueId) {
        VintageEngineDescriptor engineDescriptor = new VintageEngineDescriptor(uniqueId);
        resolver.resolve(discoveryRequest, engineDescriptor);
        RunnerTestDescriptorPostProcessor postProcessor = new RunnerTestDescriptorPostProcessor();
        for (TestDescriptor testDescriptor : engineDescriptor.getChildren()) {
            RunnerTestDescriptor runnerTestDescriptor = (RunnerTestDescriptor)testDescriptor;
            postProcessor.applyFiltersAndCreateDescendants(runnerTestDescriptor);
        }
        if (VintageDiscoverer.isDiscoveryIssueReportingEnabled(discoveryRequest) && !engineDescriptor.getChildren().isEmpty()) {
            DiscoveryIssue issue = DiscoveryIssue.create(DiscoveryIssue.Severity.INFO, "The JUnit Vintage engine is deprecated and should only be used temporarily while migrating tests to JUnit Jupiter or another testing framework with native JUnit Platform support.");
            discoveryRequest.getDiscoveryListener().issueEncountered(uniqueId, issue);
        }
        return engineDescriptor;
    }

    private static boolean isDiscoveryIssueReportingEnabled(EngineDiscoveryRequest discoveryRequest) {
        return discoveryRequest.getConfigurationParameters().getBoolean("junit.vintage.discovery.issue.reporting.enabled").orElse(true);
    }
}

