/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.suite.engine;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

class SuiteLauncher {
    private final EngineExecutionOrchestrator executionOrchestrator = new EngineExecutionOrchestrator();
    private final EngineDiscoveryOrchestrator discoveryOrchestrator;

    static SuiteLauncher create() {
        LinkedHashSet<TestEngine> engines = new LinkedHashSet<TestEngine>();
        new ServiceLoaderTestEngineRegistry().loadTestEngines().forEach(engines::add);
        return new SuiteLauncher(engines);
    }

    private SuiteLauncher(Set<TestEngine> testEngines) {
        Preconditions.condition(this.hasTestEngineOtherThanSuiteEngine(testEngines), () -> "Cannot create SuiteLauncher without at least one other TestEngine; consider adding an engine implementation JAR to the classpath");
        this.discoveryOrchestrator = new EngineDiscoveryOrchestrator(testEngines, Collections.emptyList());
    }

    private boolean hasTestEngineOtherThanSuiteEngine(Set<TestEngine> testEngines) {
        return testEngines.stream().anyMatch(testEngine -> !"junit-platform-suite".equals(testEngine.getId()));
    }

    LauncherDiscoveryResult discover(LauncherDiscoveryRequest discoveryRequest, UniqueId parentId) {
        return this.discoveryOrchestrator.discover(discoveryRequest, parentId);
    }

    TestExecutionSummary execute(LauncherDiscoveryResult discoveryResult, EngineExecutionListener executionListener, NamespacedHierarchicalStore<Namespace> requestLevelStore, CancellationToken cancellationToken) {
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        this.executionOrchestrator.execute(discoveryResult, executionListener, (TestExecutionListener)listener, requestLevelStore, cancellationToken);
        return listener.getSummary();
    }
}

