/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.legacy;

import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

@API(status=API.Status.MAINTAINED, since="1.6")
public final class LegacyReportingUtils {
    private LegacyReportingUtils() {
    }

    public static String getClassName(TestPlan testPlan, TestIdentifier testIdentifier) {
        Preconditions.notNull(testPlan, "testPlan must not be null");
        Preconditions.notNull(testIdentifier, "testIdentifier must not be null");
        TestIdentifier current = testIdentifier;
        while (current != null) {
            ClassSource source = LegacyReportingUtils.getClassSource(current);
            if (source != null) {
                return source.getClassName();
            }
            current = LegacyReportingUtils.getParent(testPlan, current);
        }
        return LegacyReportingUtils.getParentLegacyReportingName(testPlan, testIdentifier);
    }

    private static @Nullable TestIdentifier getParent(TestPlan testPlan, TestIdentifier testIdentifier) {
        return testPlan.getParent(testIdentifier).orElse(null);
    }

    private static @Nullable ClassSource getClassSource(TestIdentifier current) {
        return current.getSource().filter(ClassSource.class::isInstance).map(ClassSource.class::cast).orElse(null);
    }

    private static String getParentLegacyReportingName(TestPlan testPlan, TestIdentifier testIdentifier) {
        return testPlan.getParent(testIdentifier).map(TestIdentifier::getLegacyReportingName).orElse("<unrooted>");
    }
}

