/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.OutputDirectoryCreator;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class HierarchicalOutputDirectoryCreator
implements OutputDirectoryCreator {
    private static final Pattern FORBIDDEN_CHARS = Pattern.compile("[^a-z0-9.,_\\-() ]", 2);
    private static final String REPLACEMENT = "_";
    private final Supplier<Path> rootDirSupplier;
    private volatile @Nullable Path rootDir;

    HierarchicalOutputDirectoryCreator(Supplier<Path> rootDirSupplier) {
        this.rootDirSupplier = rootDirSupplier;
    }

    @Override
    public Path createOutputDirectory(TestDescriptor testDescriptor) throws IOException {
        Preconditions.notNull(testDescriptor, "testDescriptor must not be null");
        List<UniqueId.Segment> segments = testDescriptor.getUniqueId().getSegments();
        Path relativePath = segments.stream().skip(1L).map(HierarchicalOutputDirectoryCreator::toSanitizedPath).reduce(HierarchicalOutputDirectoryCreator.toSanitizedPath(segments.get(0)), Path::resolve);
        return Files.createDirectories(this.getRootDirectory().resolve(relativePath), new FileAttribute[0]);
    }

    @Override
    public synchronized Path getRootDirectory() {
        Path currentRootDir = this.rootDir;
        if (currentRootDir == null) {
            this.rootDir = currentRootDir = this.rootDirSupplier.get();
        }
        return currentRootDir;
    }

    private static Path toSanitizedPath(UniqueId.Segment segment) {
        return Path.of(HierarchicalOutputDirectoryCreator.sanitizeName(segment.getValue()), new String[0]);
    }

    private static String sanitizeName(String value) {
        return FORBIDDEN_CHARS.matcher(value).replaceAll(REPLACEMENT);
    }
}

