/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.CancellationToken;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherExecutionRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.InternalTestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.LauncherExecutionRequestBuilder;
import org.junit.platform.launcher.core.LauncherListenerRegistry;
import org.junit.platform.launcher.core.LauncherPhase;

class DefaultLauncher
implements Launcher {
    private final LauncherListenerRegistry listenerRegistry = new LauncherListenerRegistry();
    private final EngineExecutionOrchestrator executionOrchestrator;
    private final EngineDiscoveryOrchestrator discoveryOrchestrator;
    private final NamespacedHierarchicalStore<Namespace> sessionLevelStore;

    DefaultLauncher(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters, NamespacedHierarchicalStore<Namespace> sessionLevelStore) {
        this.executionOrchestrator = new EngineExecutionOrchestrator(this.listenerRegistry.testExecutionListeners);
        Preconditions.condition(testEngines.iterator().hasNext(), () -> "Cannot create Launcher without at least one TestEngine; consider adding an engine implementation JAR to the classpath");
        Preconditions.notNull(postDiscoveryFilters, "PostDiscoveryFilter array must not be null");
        Preconditions.containsNoNullElements(postDiscoveryFilters, "PostDiscoveryFilter array must not contain null elements");
        this.discoveryOrchestrator = new EngineDiscoveryOrchestrator(testEngines, Collections.unmodifiableCollection(postDiscoveryFilters), this.listenerRegistry.launcherDiscoveryListeners);
        this.sessionLevelStore = sessionLevelStore;
    }

    @Override
    public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
        this.listenerRegistry.launcherDiscoveryListeners.addAll((LauncherDiscoveryListener[])listeners);
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        this.listenerRegistry.testExecutionListeners.addAll((TestExecutionListener[])listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        return InternalTestPlan.from(this.discover(discoveryRequest, LauncherPhase.DISCOVERY));
    }

    @Override
    public void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        LauncherExecutionRequest executionRequest = LauncherExecutionRequestBuilder.request(discoveryRequest).listeners(listeners).build();
        this.execute(executionRequest);
    }

    @Override
    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        LauncherExecutionRequest executionRequest = LauncherExecutionRequestBuilder.request(testPlan).listeners(listeners).build();
        this.execute(executionRequest);
    }

    @Override
    public void execute(LauncherExecutionRequest launcherExecutionRequest) {
        InternalTestPlan testPlan = launcherExecutionRequest.getTestPlan().map(it -> {
            Preconditions.condition(it instanceof InternalTestPlan, "TestPlan was not returned by this Launcher");
            return (InternalTestPlan)it;
        }).orElseGet(() -> {
            Preconditions.condition(launcherExecutionRequest.getDiscoveryRequest().isPresent(), "Either a TestPlan or LauncherDiscoveryRequest must be present in the LauncherExecutionRequest");
            return InternalTestPlan.from(this.discover(launcherExecutionRequest.getDiscoveryRequest().get(), LauncherPhase.EXECUTION));
        });
        this.execute(testPlan, launcherExecutionRequest.getAdditionalTestExecutionListeners(), launcherExecutionRequest.getCancellationToken());
    }

    private LauncherDiscoveryResult discover(LauncherDiscoveryRequest discoveryRequest, LauncherPhase phase) {
        return this.discoveryOrchestrator.discover(discoveryRequest, phase);
    }

    private void execute(InternalTestPlan internalTestPlan, Collection<? extends TestExecutionListener> listeners, CancellationToken cancellationToken) {
        try (NamespacedHierarchicalStore<Namespace> requestLevelStore = this.createRequestLevelStore();){
            this.executionOrchestrator.execute(internalTestPlan, requestLevelStore, listeners, cancellationToken);
        }
    }

    private NamespacedHierarchicalStore<Namespace> createRequestLevelStore() {
        return new NamespacedHierarchicalStore<Namespace>(this.sessionLevelStore, NamespacedHierarchicalStore.CloseAction.closeAutoCloseables());
    }
}

