/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.MethodFilter;

abstract class AbstractMethodFilter
implements MethodFilter {
    protected final List<Pattern> patterns;
    protected final String patternDescription;

    AbstractMethodFilter(String ... patterns) {
        Preconditions.notEmpty(patterns, "patterns array must not be null or empty");
        Preconditions.containsNoNullElements(patterns, "patterns array must not contain null elements");
        this.patterns = Arrays.stream(patterns).map(Pattern::compile).toList();
        this.patternDescription = Arrays.stream(patterns).collect(Collectors.joining("' OR '", "'", "'"));
    }

    protected Optional<Pattern> findMatchingPattern(@Nullable String methodName) {
        if (methodName == null) {
            return Optional.empty();
        }
        return this.patterns.stream().filter(pattern -> pattern.matcher(methodName).matches()).findAny();
    }

    protected @Nullable String getFullyQualifiedMethodNameFromDescriptor(TestDescriptor descriptor) {
        return descriptor.getSource().filter(MethodSource.class::isInstance).map(methodSource -> this.getFullyQualifiedMethodNameWithoutParameters((MethodSource)methodSource)).orElse(null);
    }

    private String getFullyQualifiedMethodNameWithoutParameters(MethodSource methodSource) {
        String methodNameWithParentheses = ReflectionUtils.getFullyQualifiedMethodName(methodSource.getJavaClass(), methodSource.getMethodName(), (Class[])null);
        return methodNameWithParentheses.substring(0, methodNameWithParentheses.length() - 2);
    }
}

