/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.store;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class NamespacedHierarchicalStore<N>
implements AutoCloseable {
    private final AtomicInteger insertOrderSequence = new AtomicInteger();
    private final ConcurrentMap<CompositeKey<N>, StoredValue> storedValues = new ConcurrentHashMap<CompositeKey<N>, StoredValue>(4);
    private final @Nullable NamespacedHierarchicalStore<N> parentStore;
    private final @Nullable CloseAction<N> closeAction;
    private volatile boolean closed = false;

    public NamespacedHierarchicalStore(@Nullable NamespacedHierarchicalStore<N> parentStore) {
        this(parentStore, null);
    }

    public NamespacedHierarchicalStore(@Nullable NamespacedHierarchicalStore<N> parentStore, @Nullable CloseAction<N> closeAction) {
        this.parentStore = parentStore;
        this.closeAction = closeAction;
    }

    public NamespacedHierarchicalStore<N> newChild() {
        return new NamespacedHierarchicalStore<N>(this, this.closeAction);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.0")
    public Optional<NamespacedHierarchicalStore<N>> getParent() {
        return Optional.ofNullable(this.parentStore);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                if (this.closeAction != null) {
                    ArrayList failures = new ArrayList();
                    this.storedValues.entrySet().stream().map(e -> EvaluatedValue.createSafely((CompositeKey)e.getKey(), (StoredValue)e.getValue())).filter(Objects::nonNull).sorted(EvaluatedValue.REVERSE_INSERT_ORDER).forEach(it -> {
                        try {
                            it.close(this.closeAction);
                        }
                        catch (Throwable t) {
                            UnrecoverableExceptions.rethrowIfUnrecoverable(t);
                            failures.add(t);
                        }
                    });
                    if (!failures.isEmpty()) {
                        Iterator<Throwable> iterator = failures.iterator();
                        Throwable throwable = (Throwable)iterator.next();
                        iterator.forEachRemaining(throwable::addSuppressed);
                        throw ExceptionUtils.throwAsUncheckedException(throwable);
                    }
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public @Nullable Object get(N namespace, Object key) {
        StoredValue storedValue = this.getStoredValue(new CompositeKey<N>(namespace, key));
        return StoredValue.evaluateIfNotNull(storedValue);
    }

    public <T> @Nullable T get(N namespace, Object key, Class<T> requiredType) throws NamespacedHierarchicalStoreException {
        Object value = this.get(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    @Deprecated(since="6.0")
    @API(status=API.Status.DEPRECATED, since="6.0")
    public <K, V> @Nullable Object getOrComputeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator) {
        StoredValue storedValue;
        Preconditions.notNull(defaultCreator, "defaultCreator must not be null");
        CompositeKey<N> compositeKey = new CompositeKey<N>(namespace, key);
        StoredValue currentStoredValue = this.getStoredValue(compositeKey);
        if (currentStoredValue != null) {
            return currentStoredValue.evaluate();
        }
        StoredValue.DeferredValue candidateStoredValue = this.newStoredSuppliedNullableValue(() -> {
            this.rejectIfClosed();
            return defaultCreator.apply((Object)key);
        });
        do {
            if (!candidateStoredValue.equals(storedValue = this.storedValues.compute(compositeKey, (__, oldStoredValue) -> {
                if (oldStoredValue != null && (!oldStoredValue.isDone() || oldStoredValue.isPresent())) {
                    return oldStoredValue;
                }
                this.rejectIfClosed();
                return candidateStoredValue;
            }))) continue;
            return candidateStoredValue.execute();
        } while (!storedValue.isPresent());
        return storedValue.evaluate();
    }

    @API(status=API.Status.MAINTAINED, since="6.0")
    public <K, V> Object computeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator) {
        StoredValue storedValue;
        Object storedResult;
        Preconditions.notNull(defaultCreator, "defaultCreator must not be null");
        CompositeKey<N> compositeKey = new CompositeKey<N>(namespace, key);
        StoredValue currentStoredValue = this.getStoredValue(compositeKey);
        Object result = StoredValue.evaluateIfNotNull(currentStoredValue);
        if (result != null) {
            return result;
        }
        StoredValue.DeferredOptionalValue candidateStoredValue = this.newStoredSuppliedValue(() -> {
            this.rejectIfClosed();
            return Preconditions.notNull(defaultCreator.apply((Object)key), "defaultCreator must not return null");
        });
        do {
            if (!candidateStoredValue.equals(storedValue = this.storedValues.compute(compositeKey, (__, oldStoredValue) -> {
                if (!(oldStoredValue == null || oldStoredValue.isDone() && oldStoredValue.evaluate() == null)) {
                    return oldStoredValue;
                }
                this.rejectIfClosed();
                return candidateStoredValue;
            }))) continue;
            Object newResult = candidateStoredValue.execute();
            if (candidateStoredValue.isPresent()) {
                this.storedValues.computeIfPresent(compositeKey, NamespacedHierarchicalStore.compareAndPut(storedValue, this.newStoredValue(newResult)));
            }
            return newResult;
        } while ((storedResult = storedValue.evaluate()) == null);
        return storedResult;
    }

    private static <N> BiFunction<CompositeKey<N>, StoredValue, StoredValue> compareAndPut(StoredValue expectedValue, StoredValue newValue) {
        return (__, storedValue) -> {
            if (expectedValue.equals(storedValue)) {
                return newValue;
            }
            return storedValue;
        };
    }

    @Deprecated(since="6.0")
    @API(status=API.Status.DEPRECATED, since="6.0")
    public <K, V> @Nullable V getOrComputeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) throws NamespacedHierarchicalStoreException {
        Object value = this.getOrComputeIfAbsent(namespace, key, defaultCreator);
        return this.castToRequiredType(key, value, requiredType);
    }

    @API(status=API.Status.MAINTAINED, since="6.0")
    public <K, V> V computeIfAbsent(N namespace, K key, Function<? super K, ? extends V> defaultCreator, Class<V> requiredType) throws NamespacedHierarchicalStoreException {
        Object value = this.computeIfAbsent(namespace, key, defaultCreator);
        return this.castNonNullToRequiredType(key, value, requiredType);
    }

    public @Nullable Object put(N namespace, Object key, @Nullable Object value) throws NamespacedHierarchicalStoreException {
        this.rejectIfClosed();
        StoredValue oldValue = this.storedValues.put(new CompositeKey<N>(namespace, key), this.newStoredValue(value));
        return StoredValue.evaluateIfNotNull(oldValue);
    }

    public @Nullable Object remove(N namespace, Object key) {
        this.rejectIfClosed();
        StoredValue previous = (StoredValue)this.storedValues.remove(new CompositeKey<N>(namespace, key));
        return StoredValue.evaluateIfNotNull(previous);
    }

    public <T> @Nullable T remove(N namespace, Object key, Class<T> requiredType) throws NamespacedHierarchicalStoreException {
        this.rejectIfClosed();
        Object value = this.remove(namespace, key);
        return this.castToRequiredType(key, value, requiredType);
    }

    private StoredValue.Value newStoredValue(@Nullable Object value) {
        int sequenceNumber = this.insertOrderSequence.getAndIncrement();
        return new StoredValue.Value(sequenceNumber, value);
    }

    private StoredValue.DeferredValue newStoredSuppliedNullableValue(Supplier<@Nullable Object> supplier) {
        int sequenceNumber = this.insertOrderSequence.getAndIncrement();
        return new StoredValue.DeferredValue(sequenceNumber, supplier);
    }

    private StoredValue.DeferredOptionalValue newStoredSuppliedValue(Supplier<Object> supplier) {
        int sequenceNumber = this.insertOrderSequence.getAndIncrement();
        return new StoredValue.DeferredOptionalValue(sequenceNumber, supplier);
    }

    private @Nullable StoredValue getStoredValue(CompositeKey<N> compositeKey) {
        StoredValue storedValue = (StoredValue)this.storedValues.get(compositeKey);
        if (StoredValue.isNonNullAndPresent(storedValue)) {
            return storedValue;
        }
        if (this.parentStore != null) {
            return this.parentStore.getStoredValue(compositeKey);
        }
        return null;
    }

    private <T> @Nullable T castToRequiredType(Object key, @Nullable Object value, Class<T> requiredType) {
        Preconditions.notNull(requiredType, "requiredType must not be null");
        if (value == null) {
            return null;
        }
        return this.castNonNullToRequiredType(key, value, requiredType);
    }

    private <T, V> T castNonNullToRequiredType(Object key, V value, Class<T> requiredType) {
        if (ReflectionUtils.isAssignableTo(value, requiredType)) {
            if (requiredType.isPrimitive()) {
                return (T)Objects.requireNonNull(ReflectionUtils.getWrapperType(requiredType)).cast(value);
            }
            return requiredType.cast(value);
        }
        throw new NamespacedHierarchicalStoreException("Object stored under key [%s] is not of required type [%s], but was [%s]: %s".formatted(key, requiredType.getName(), value.getClass().getName(), value));
    }

    private void rejectIfClosed() {
        if (this.closed) {
            throw new NamespacedHierarchicalStoreException("A NamespacedHierarchicalStore cannot be modified or queried after it has been closed");
        }
    }

    @FunctionalInterface
    public static interface CloseAction<N> {
        @API(status=API.Status.EXPERIMENTAL, since="6.0")
        public static <N> CloseAction<N> closeAutoCloseables() {
            return (__, ___, value) -> {
                if (value instanceof AutoCloseable) {
                    AutoCloseable closeable = (AutoCloseable)value;
                    closeable.close();
                }
            };
        }

        public void close(N var1, Object var2, Object var3) throws Throwable;
    }

    private record EvaluatedValue<N>(CompositeKey<N> compositeKey, int order, Object value) {
        private static final Comparator<EvaluatedValue<?>> REVERSE_INSERT_ORDER = Comparator.comparing(it -> it.order).reversed();

        private static <N> @Nullable EvaluatedValue<N> createSafely(CompositeKey<N> compositeKey, StoredValue value) {
            try {
                Object evaluatedValue = value.evaluate();
                if (evaluatedValue == null) {
                    return null;
                }
                return new EvaluatedValue<N>(compositeKey, value.order(), evaluatedValue);
            }
            catch (Throwable t) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(t);
                return null;
            }
        }

        private void close(CloseAction<N> closeAction) throws Throwable {
            closeAction.close(this.compositeKey.namespace, this.compositeKey.key, this.value);
        }
    }

    private record CompositeKey<N>(N namespace, Object key) {
        CompositeKey {
            Preconditions.notNull(namespace, "namespace must not be null");
            Preconditions.notNull(key, "key must not be null");
        }
    }

    private static interface StoredValue {
        public int order();

        public @Nullable Object evaluate();

        public boolean isPresent();

        public boolean isDone();

        public static @Nullable Object evaluateIfNotNull(@Nullable StoredValue value) {
            return value != null ? value.evaluate() : null;
        }

        public static boolean isNonNullAndPresent(@Nullable StoredValue value) {
            return value != null && value.isPresent();
        }

        public static final class DeferredOptionalValue
        implements StoredValue {
            private final int order;
            private final DeferredSupplier delegate;

            DeferredOptionalValue(int order, Supplier<Object> delegate) {
                this.order = order;
                this.delegate = new DeferredSupplier(delegate);
            }

            @Override
            public @Nullable Object evaluate() {
                return this.delegate.get();
            }

            @Override
            public boolean isPresent() {
                return this.evaluate() != null;
            }

            @Override
            public boolean isDone() {
                return this.delegate.isDone();
            }

            Object execute() {
                this.delegate.run();
                return Objects.requireNonNull(this.delegate.getOrThrow());
            }

            @Override
            public int order() {
                return this.order;
            }
        }

        public static final class DeferredValue
        implements StoredValue {
            private final int order;
            private final DeferredSupplier delegate;

            DeferredValue(int order, Supplier<@Nullable Object> delegate) {
                this.order = order;
                this.delegate = new DeferredSupplier(delegate);
            }

            @Override
            public @Nullable Object evaluate() {
                return this.delegate.getOrThrow();
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public boolean isDone() {
                return this.delegate.isDone();
            }

            @Nullable Object execute() {
                this.delegate.run();
                return this.delegate.getOrThrow();
            }

            @Override
            public int order() {
                return this.order;
            }
        }

        public static final class Value
        implements StoredValue {
            private final int order;
            private final @Nullable Object value;

            Value(int order, @Nullable Object value) {
                this.order = order;
                this.value = value;
            }

            @Override
            public @Nullable Object evaluate() {
                return this.value;
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public int order() {
                return this.order;
            }
        }
    }

    static final class DeferredSupplier {
        private final FutureTask<@Nullable Object> task = new FutureTask<Object>(delegate::get);

        DeferredSupplier(Supplier<?> delegate) {
        }

        void run() {
            this.task.run();
        }

        @Nullable Object get() {
            try {
                return this.task.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ExceptionUtils.throwAsUncheckedException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = Objects.requireNonNull(e.getCause());
                UnrecoverableExceptions.rethrowIfUnrecoverable(cause);
                return null;
            }
        }

        @Nullable Object getOrThrow() {
            try {
                return this.task.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ExceptionUtils.throwAsUncheckedException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = Objects.requireNonNull(e.getCause());
                UnrecoverableExceptions.rethrowIfUnrecoverable(cause);
                throw ExceptionUtils.throwAsUncheckedException(cause);
            }
        }

        boolean isDone() {
            return this.task.isDone();
        }
    }
}

