/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.support.hierarchical.DefaultParallelExecutionConfigurationStrategy;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.HierarchicalTestExecutorService;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfiguration;
import org.junit.platform.engine.support.hierarchical.ParallelExecutionConfigurationStrategy;
import org.junit.platform.engine.support.hierarchical.ResourceLock;

@API(status=API.Status.STABLE, since="1.10")
public class ForkJoinPoolHierarchicalTestExecutorService
implements HierarchicalTestExecutorService {
    final ForkJoinPool forkJoinPool;
    private final TaskEventListener taskEventListener;
    private final int parallelism;
    private final ThreadLocal<ThreadLock> threadLocks = ThreadLocal.withInitial(ThreadLock::new);

    public ForkJoinPoolHierarchicalTestExecutorService(ConfigurationParameters configurationParameters) {
        this(ForkJoinPoolHierarchicalTestExecutorService.createConfiguration(configurationParameters));
    }

    @API(status=API.Status.STABLE, since="1.10")
    public ForkJoinPoolHierarchicalTestExecutorService(ParallelExecutionConfiguration configuration) {
        this(configuration, TaskEventListener.NOOP);
    }

    ForkJoinPoolHierarchicalTestExecutorService(ParallelExecutionConfiguration configuration, TaskEventListener taskEventListener) {
        this.forkJoinPool = this.createForkJoinPool(configuration);
        this.taskEventListener = taskEventListener;
        this.parallelism = this.forkJoinPool.getParallelism();
        LoggerFactory.getLogger(this.getClass()).config(() -> "Using ForkJoinPool with parallelism of " + this.parallelism);
    }

    private static ParallelExecutionConfiguration createConfiguration(ConfigurationParameters configurationParameters) {
        ParallelExecutionConfigurationStrategy strategy = DefaultParallelExecutionConfigurationStrategy.getStrategy(configurationParameters);
        return strategy.createConfiguration(configurationParameters);
    }

    private ForkJoinPool createForkJoinPool(ParallelExecutionConfiguration configuration) {
        try {
            return new ForkJoinPool(configuration.getParallelism(), new WorkerThreadFactory(), null, false, configuration.getCorePoolSize(), configuration.getMaxPoolSize(), configuration.getMinimumRunnable(), configuration.getSaturatePredicate(), configuration.getKeepAliveSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception cause) {
            throw new JUnitException("Failed to create ForkJoinPool", cause);
        }
    }

    @Override
    public Future<@Nullable Void> submit(HierarchicalTestExecutorService.TestTask testTask) {
        ExclusiveTask exclusiveTask = new ExclusiveTask(testTask);
        if (!this.isAlreadyRunningInForkJoinPool()) {
            return this.forkJoinPool.submit(exclusiveTask);
        }
        if (testTask.getExecutionMode() == Node.ExecutionMode.CONCURRENT && ForkJoinTask.getSurplusQueuedTaskCount() < this.parallelism) {
            return exclusiveTask.fork();
        }
        exclusiveTask.execSync();
        return CompletableFuture.completedFuture(null);
    }

    private boolean isAlreadyRunningInForkJoinPool() {
        return ForkJoinTask.getPool() == this.forkJoinPool;
    }

    @Override
    public void invokeAll(List<? extends HierarchicalTestExecutorService.TestTask> tasks) {
        if (tasks.size() == 1) {
            new ExclusiveTask(tasks.get(0)).execSync();
            return;
        }
        ArrayDeque<ExclusiveTask> isolatedTasks = new ArrayDeque<ExclusiveTask>();
        ArrayDeque<ExclusiveTask> sameThreadTasks = new ArrayDeque<ExclusiveTask>();
        ArrayDeque<ExclusiveTask> concurrentTasksInReverseOrder = new ArrayDeque<ExclusiveTask>();
        this.forkConcurrentTasks(tasks, isolatedTasks, sameThreadTasks, concurrentTasksInReverseOrder);
        this.executeSync(sameThreadTasks);
        this.joinConcurrentTasksInReverseOrderToEnableWorkStealing(concurrentTasksInReverseOrder);
        this.executeSync(isolatedTasks);
    }

    private void forkConcurrentTasks(List<? extends HierarchicalTestExecutorService.TestTask> tasks, Deque<ExclusiveTask> isolatedTasks, Deque<ExclusiveTask> sameThreadTasks, Deque<ExclusiveTask> concurrentTasksInReverseOrder) {
        for (HierarchicalTestExecutorService.TestTask testTask : tasks) {
            ExclusiveTask exclusiveTask = new ExclusiveTask(testTask);
            if (ForkJoinPoolHierarchicalTestExecutorService.requiresGlobalReadWriteLock(testTask)) {
                isolatedTasks.add(exclusiveTask);
                continue;
            }
            if (testTask.getExecutionMode() == Node.ExecutionMode.SAME_THREAD) {
                sameThreadTasks.add(exclusiveTask);
                continue;
            }
            exclusiveTask.fork();
            concurrentTasksInReverseOrder.addFirst(exclusiveTask);
        }
    }

    private static boolean requiresGlobalReadWriteLock(HierarchicalTestExecutorService.TestTask testTask) {
        return testTask.getResourceLock().getResources().contains(ExclusiveResource.GLOBAL_READ_WRITE);
    }

    private void executeSync(Deque<ExclusiveTask> tasks) {
        for (ExclusiveTask task : tasks) {
            task.execSync();
        }
    }

    private void joinConcurrentTasksInReverseOrderToEnableWorkStealing(Deque<ExclusiveTask> concurrentTasksInReverseOrder) {
        for (ExclusiveTask forkedTask : concurrentTasksInReverseOrder) {
            forkedTask.join();
            this.resubmitDeferredTasks();
        }
    }

    private void resubmitDeferredTasks() {
        List<ExclusiveTask> deferredTasks = this.threadLocks.get().deferredTasks;
        for (ExclusiveTask deferredTask : deferredTasks) {
            if (deferredTask.isDone()) continue;
            deferredTask.fork();
        }
        deferredTasks.clear();
    }

    @Override
    public void close() {
        this.forkJoinPool.shutdownNow();
    }

    static interface TaskEventListener {
        public static final TaskEventListener NOOP = __ -> {};

        public void deferred(HierarchicalTestExecutorService.TestTask var1);
    }

    static class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        WorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new WorkerThread(pool, this.contextClassLoader);
        }
    }

    class ExclusiveTask
    extends ForkJoinTask<Void> {
        private static final long serialVersionUID = 1L;
        private final HierarchicalTestExecutorService.TestTask testTask;

        ExclusiveTask(HierarchicalTestExecutorService.TestTask testTask) {
            this.testTask = testTask;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        protected final void setRawResult(Void mustBeNull) {
        }

        void execSync() {
            boolean completed = this.exec();
            if (!completed) {
                throw new IllegalStateException("Task was deferred but should have been executed synchronously: " + String.valueOf(this.testTask));
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean exec() {
            ResourceLock resourceLock = this.testTask.getResourceLock();
            ThreadLock threadLock = ForkJoinPoolHierarchicalTestExecutorService.this.threadLocks.get();
            if (!threadLock.areAllHeldLocksCompatibleWith(resourceLock)) {
                threadLock.addDeferredTask(this);
                ForkJoinPoolHierarchicalTestExecutorService.this.taskEventListener.deferred(this.testTask);
                return false;
            }
            try (ResourceLock lock = resourceLock.acquire();){
                ThreadLock.NestedResourceLock nested = threadLock.withNesting(lock);
                try {
                    this.testTask.execute();
                    boolean bl = true;
                    if (nested != null) {
                        nested.close();
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (nested != null) {
                        try {
                            nested.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.throwAsUncheckedException(e);
            }
        }

        public String toString() {
            return "ExclusiveTask [" + String.valueOf(this.testTask) + "]";
        }
    }

    static class ThreadLock {
        private final Deque<ResourceLock> locks = new ArrayDeque<ResourceLock>(2);
        private final List<ExclusiveTask> deferredTasks = new ArrayList<ExclusiveTask>();

        ThreadLock() {
        }

        void addDeferredTask(ExclusiveTask task) {
            this.deferredTasks.add(task);
        }

        NestedResourceLock withNesting(ResourceLock lock) {
            this.locks.push(lock);
            return this.locks::pop;
        }

        boolean areAllHeldLocksCompatibleWith(ResourceLock lock) {
            return this.locks.stream().allMatch(l -> l.isCompatible(lock));
        }

        static interface NestedResourceLock
        extends AutoCloseable {
            @Override
            public void close();
        }
    }

    static class WorkerThread
    extends ForkJoinWorkerThread {
        WorkerThread(ForkJoinPool pool, ClassLoader contextClassLoader) {
            super(pool);
            this.setContextClassLoader(contextClassLoader);
        }
    }
}

